/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.metricssampler.cmd.ControlCommand;

@Parameters(commandNames={"sampler"}, commandDescriptionKey="help.sampler.command")
public class SamplerCommand
extends ControlCommand {
    @Parameter(names={"-n"}, descriptionKey="help.param.sampler.samplers", required=true)
    protected List<String> samplers = new LinkedList<String>();
    @Parameter(names={"-a"}, descriptionKey="help.param.sampler.action", required=true)
    protected String action;

    @Override
    protected void runBootstrapped() {
        for (String sampler : this.samplers) {
            String prefix = this.action + " sampler \"" + sampler + "\": ";
            try {
                String response = this.execute(this.bootstrapper.getControlHost(), this.bootstrapper.getControlPort(), "sampler " + sampler + " " + this.action);
                System.out.println(prefix + response);
            }
            catch (UnknownHostException e) {
                System.err.println(prefix + e.getMessage());
            }
            catch (IOException e) {
                System.err.println(prefix + e.getMessage());
            }
        }
    }
}

