/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.metricssampler.cmd.ConfigurationCommand;
import org.metricssampler.resources.SamplerStats;
import org.metricssampler.sampler.Sampler;

public abstract class SamplersCommand
extends ConfigurationCommand {
    @Parameter(names={"-n"}, descriptionKey="help.param.samplers")
    protected List<String> samplers = new LinkedList<String>();

    @Override
    protected void runBootstrapped() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.samplers);
        this.preProcess();
        for (Sampler sampler : this.bootstrapper.getSamplers()) {
            if (!names.isEmpty() && !names.contains(sampler.getConfig().getName())) continue;
            SamplerStats.init();
            try {
                this.process(sampler);
            }
            catch (RuntimeException e) {
                this.logger.warn("Sampler threw exception. Ignoring", (Throwable)e);
            }
            SamplerStats.unset();
        }
        this.postProcess();
    }

    protected void preProcess() {
    }

    protected abstract void process(Sampler var1);

    protected void postProcess() {
    }
}

