/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.cmd;

import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.net.ConnectException;
import org.metricssampler.cmd.ControlCommand;

@Parameters(commandNames={"status"}, commandDescriptionKey="help.status.command")
public class StatusCommand
extends ControlCommand {
    @Override
    protected void runBootstrapped() {
        String msg = this.checkStatus(this.bootstrapper.getControlHost(), this.bootstrapper.getControlPort());
        System.out.println(msg);
        System.exit(msg.startsWith("Running [") ? 0 : 1);
    }

    protected String checkStatus(String host, int port) {
        try {
            String response = this.execute(host, port, "status").trim();
            if ("ok".equals(response)) {
                return "Running [port " + port + "]";
            }
            return "Running on control port " + port + " but responded with: \"" + response + "\"";
        }
        catch (ConnectException e) {
            return "Stopped";
        }
        catch (IOException e) {
            return "Unknown state: " + e.getMessage();
        }
    }
}

