/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.metricssampler.config.HttpConnectionPoolConfig;
import org.metricssampler.config.InputConfig;
import org.metricssampler.config.SocketOptionsConfig;
import org.metricssampler.util.Preconditions;

public abstract class BaseHttpInputConfig
extends InputConfig {
    private final URL url;
    private final String username;
    private final String password;
    private final Map<String, String> headers;
    private final boolean preemptiveAuthEnabled;
    private final SocketOptionsConfig socketOptions;
    private final HttpConnectionPoolConfig connectionPool;

    protected BaseHttpInputConfig(String name, Map<String, Object> variables, URL url, String username, String password, Map<String, String> headers, boolean preemptiveAuthEnabled, SocketOptionsConfig socketOptions, HttpConnectionPoolConfig connectionPool) {
        super(name, variables);
        Preconditions.checkArgumentNotNull(url, "url");
        Preconditions.checkArgumentNotNull(headers, "headers");
        this.url = url;
        this.username = username;
        this.password = password;
        this.headers = Collections.unmodifiableMap(headers);
        this.preemptiveAuthEnabled = preemptiveAuthEnabled;
        this.socketOptions = socketOptions;
        this.connectionPool = connectionPool;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isPreemptiveAuthEnabled() {
        return this.preemptiveAuthEnabled;
    }

    public SocketOptionsConfig getSocketOptions() {
        return this.socketOptions;
    }

    public HttpConnectionPoolConfig getConnectionPool() {
        return this.connectionPool;
    }
}

