/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.metricssampler.config.InputConfig;
import org.metricssampler.config.OutputConfig;
import org.metricssampler.config.SamplerConfig;
import org.metricssampler.config.SharedResourceConfig;
import org.metricssampler.util.Preconditions;

public class Configuration {
    private final Collection<InputConfig> inputs;
    private final Collection<OutputConfig> outputs;
    private final Collection<SamplerConfig> samplers;
    private final Map<String, Object> variables;
    private final Map<String, SharedResourceConfig> sharedResources;

    public Configuration(Collection<InputConfig> inputs, Collection<OutputConfig> outputs, Collection<SamplerConfig> samplers, Map<String, Object> variables, Map<String, SharedResourceConfig> sharedResources) {
        Preconditions.checkArgumentNotNull(inputs, "inputs");
        Preconditions.checkArgumentNotNull(outputs, "outputs");
        Preconditions.checkArgumentNotNull(samplers, "samplers");
        Preconditions.checkArgumentNotNull(variables, "variables");
        Preconditions.checkArgumentNotNull(sharedResources, "sharedResources");
        this.inputs = Collections.unmodifiableCollection(inputs);
        this.outputs = Collections.unmodifiableCollection(outputs);
        this.samplers = Collections.unmodifiableCollection(samplers);
        this.variables = Collections.unmodifiableMap(variables);
        this.sharedResources = Collections.unmodifiableMap(sharedResources);
    }

    public Collection<InputConfig> getInputs() {
        return this.inputs;
    }

    public Collection<OutputConfig> getOutputs() {
        return this.outputs;
    }

    public Collection<SamplerConfig> getSamplers() {
        return this.samplers;
    }

    public Map<String, SharedResourceConfig> getSharedResources() {
        return this.sharedResources;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

