/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.metricssampler.config.NamedConfig;
import org.metricssampler.config.ValueTransformerConfig;
import org.metricssampler.util.Preconditions;

public abstract class SamplerConfig
extends NamedConfig {
    private final String pool;
    private final int interval;
    private final boolean ignored;
    private final boolean disabled;
    private final Map<String, Object> globalVariables;
    private final List<ValueTransformerConfig> valueTransformers;

    public SamplerConfig(String name, String pool, int interval, boolean ignored, boolean disabled, Map<String, Object> globalVariables, List<ValueTransformerConfig> valueTransformers) {
        super(name);
        Preconditions.checkArgumentNotNull(pool, "pool");
        Preconditions.checkArgument(interval > 0, "interval must be greater than 0 seconds");
        Preconditions.checkArgumentNotNull(globalVariables, "globalVariables");
        Preconditions.checkArgumentNotNull(valueTransformers, "valueTransformers");
        this.pool = pool;
        this.interval = interval;
        this.ignored = ignored;
        this.disabled = disabled;
        this.globalVariables = Collections.unmodifiableMap(globalVariables);
        this.valueTransformers = Collections.unmodifiableList(valueTransformers);
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<ValueTransformerConfig> getValueTransformers() {
        return this.valueTransformers;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getPool() {
        return this.pool;
    }
}

