/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config;

public class SocketOptionsConfig {
    private final int connectTimeout;
    private final int soTimeout;
    private final boolean keepAlive;
    private final int sndBuffSize;
    private final int rcvBuffSize;

    public SocketOptionsConfig(int connectTimeout, int soTimeout, boolean keepAlive, int sndBuffSize, int rcvBuffSize) {
        this.connectTimeout = connectTimeout;
        this.soTimeout = soTimeout;
        this.keepAlive = keepAlive;
        this.sndBuffSize = sndBuffSize;
        this.rcvBuffSize = rcvBuffSize;
    }

    public boolean hasConnectTimeout() {
        return this.connectTimeout > 0;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean hasSoTimeout() {
        return this.soTimeout > 0;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean hasSndBuffSize() {
        return this.sndBuffSize > 0;
    }

    public int getSndBuffSize() {
        return this.sndBuffSize;
    }

    public int getRcvBuffSize() {
        return this.rcvBuffSize;
    }

    public boolean hasRcvBuffSize() {
        return this.rcvBuffSize > 0;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(this.getClass().getSimpleName()).append("[");
        if (this.hasConnectTimeout()) {
            msg.append("connect timeout = ").append(this.getSoTimeout()).append(" ms ");
        }
        if (this.hasSoTimeout()) {
            msg.append("socket timeout = ").append(this.getSoTimeout()).append(" ms ");
        }
        if (this.hasSndBuffSize()) {
            msg.append("send buffer size = ").append(this.getSndBuffSize()).append(" ");
        }
        if (this.hasRcvBuffSize()) {
            msg.append("receive buffer size = ").append(this.getRcvBuffSize()).append(" ");
        }
        msg.append("keep alive = ").append(this.isKeepAlive()).append("]");
        return msg.toString();
    }
}

