/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.ReaderWrapper;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.Xpp3DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.metricssampler.config.Configuration;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.loader.FileGlobProcessor;
import org.metricssampler.config.loader.XBeanPostProcessor;
import org.metricssampler.config.loader.xbeans.ConfigurationXBean;
import org.metricssampler.config.loader.xbeans.IncludeXBean;
import org.metricssampler.config.loader.xbeans.XBean;
import org.metricssampler.util.Preconditions;
import org.metricssampler.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Collection<Class<?>> xbeanClasses;
    private final List<XBeanPostProcessor> xbeanPostProcessors;
    private final HierarchicalStreamDriver driver = new Xpp3DomDriver();

    public ConfigurationLoader(Collection<Class<?>> xbeanClasses, List<XBeanPostProcessor> xbeanPostProcessors) {
        Preconditions.checkArgumentNotNullNorEmpty(xbeanClasses, "xbeanClasses");
        this.xbeanClasses = xbeanClasses;
        this.xbeanPostProcessors = xbeanPostProcessors;
    }

    public static Configuration fromFile(String filename, Collection<Class<?>> xbeanClasses, List<XBeanPostProcessor> xbeanPostProcessors) {
        return new ConfigurationLoader(xbeanClasses, xbeanPostProcessors).load(filename);
    }

    protected Configuration load(String filename) {
        Preconditions.checkArgumentNotNullNorEmpty(filename, "filename");
        File file = new File(filename);
        XStream xstream = this.createXStream();
        try {
            ConfigurationXBean result = this.loadFile(file, xstream);
            this.applyPostProcessing(result);
            return result.toConfig();
        }
        catch (XStreamException | IOException e) {
            throw new ConfigurationException("Failed to load configuration from \"" + file.getAbsolutePath() + "\"", e);
        }
    }

    private void applyPostProcessing(XBean bean) {
        try {
            for (XBeanPostProcessor postProcessor : this.xbeanPostProcessors) {
                postProcessor.postProcessAfterLoad(bean);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("Failed to execute post processors", e);
        }
    }

    protected ConfigurationXBean loadFile(File file, XStream xstream) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            TrimmingReaderWrapper reader = new TrimmingReaderWrapper(this.driver.createReader((InputStream)fis));
            ConfigurationXBean result = (ConfigurationXBean)xstream.unmarshal((HierarchicalStreamReader)reader);
            if (result.getIncludes() != null) {
                for (IncludeXBean include : result.getIncludes()) {
                    this.logger.info("Including files matching \"{}\"", (Object)include.getLocation());
                    File basedir = file.getParentFile();
                    this.include(basedir != null ? basedir : new File("."), include.getLocation(), xstream, result);
                }
            }
            ConfigurationXBean configurationXBean = result;
            return configurationXBean;
        }
    }

    protected void include(File basedir, String location, final XStream xstream, final ConfigurationXBean result) {
        FileGlobProcessor.visitMatching(basedir, location, new FileGlobProcessor.MatchingFileVisitor(){

            @Override
            public void visit(File file) {
                ConfigurationLoader.this.logger.info("Including file {}", (Object)file);
                ConfigurationXBean includedConfig = (ConfigurationXBean)xstream.fromXML(file);
                result.include(includedConfig);
            }
        });
    }

    protected XStream createXStream() {
        XStream result = new XStream((HierarchicalStreamDriver)new DomDriver());
        for (Class<?> clazz : this.xbeanClasses) {
            result.processAnnotations(clazz);
        }
        return result;
    }

    private static class TrimmingReaderWrapper
    extends ReaderWrapper {
        protected TrimmingReaderWrapper(HierarchicalStreamReader reader) {
            super(reader);
        }

        public String getValue() {
            return StringUtils.trim(super.getValue());
        }

        public String getAttribute(String name) {
            return StringUtils.trim(super.getAttribute(name));
        }

        public String getAttribute(int index) {
            return StringUtils.trim(super.getAttribute(index));
        }
    }
}

