/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader;

import java.io.File;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class FileGlob {
    private final PathSegmentPattern[] patterns;

    public static String[] tokenize(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter path may not be null");
        }
        int len = path.length();
        int prev = 0;
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c != '/' && c != '\\') continue;
            result.add(path.substring(prev, i));
            prev = i + 1;
        }
        if (prev < len) {
            result.add(path.substring(prev));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String relativePath(File file, File basedir) {
        char firstChar;
        String basePath;
        String filePath = file.getPath();
        String shouldBeBasePath = filePath.substring(0, (basePath = basedir.getPath()).length());
        if (!shouldBeBasePath.equals(basePath)) {
            throw new IllegalArgumentException(file + " is not a descendant of " + basedir);
        }
        String path = filePath.substring(basePath.length(), filePath.length());
        if (path.length() > 0 && ((firstChar = path.charAt(0)) == '/' || firstChar == '\\')) {
            return path.substring(1, path.length());
        }
        return path;
    }

    public FileGlob(String expression) {
        this.patterns = FileGlob.compileExpression(expression);
    }

    public boolean matches(File file, File basedir) {
        String relativePath = FileGlob.relativePath(file, basedir);
        String[] pathItems = FileGlob.tokenize(relativePath);
        return this.internalMatches(pathItems, 0, 0);
    }

    protected boolean internalMatches(String[] paths, int patternIndex, int pathIndex) {
        boolean isDirectory;
        if (pathIndex == paths.length) {
            return true;
        }
        if (patternIndex == this.patterns.length) {
            return false;
        }
        String path = paths[pathIndex];
        PathSegmentPattern pattern = this.patterns[patternIndex];
        boolean bl = isDirectory = pathIndex != paths.length - 1;
        if (pattern.matches(path, isDirectory)) {
            boolean result;
            if (pattern.isReusable() && (result = this.internalMatches(paths, patternIndex, pathIndex + 1))) {
                return true;
            }
            return this.internalMatches(paths, patternIndex + 1, pathIndex + 1);
        }
        if (pattern.isOptional()) {
            return this.internalMatches(paths, patternIndex + 1, pathIndex);
        }
        return false;
    }

    public static PathSegmentPattern[] compileExpression(String expression) {
        String[] tokens = FileGlob.tokenize(expression);
        PathSegmentPattern[] patterns = new PathSegmentPattern[tokens.length];
        int i = 0;
        for (String token : tokens) {
            if ("**".equals(token)) {
                patterns[i] = new AnyPathSegmentPattern(true);
            } else {
                boolean isDirectoryToken = i != tokens.length - 1;
                patterns[i] = token.contains("*") ? new NameExpressionPathSegmentPattern(token, isDirectoryToken) : new NamePathSegmentPattern(token, isDirectoryToken);
            }
            ++i;
        }
        return patterns;
    }

    public static class NameExpressionPathSegmentPattern
    extends PathSegmentPattern {
        private final String expression;
        private final boolean directory;
        private final Pattern pattern;

        public NameExpressionPathSegmentPattern(String expression, boolean directory) {
            super(false, false);
            this.expression = expression;
            this.directory = directory;
            this.pattern = Pattern.compile(expression.replaceAll("\\*", ".*"));
        }

        @Override
        public boolean matches(String name, boolean directory) {
            if (this.directory == directory) {
                return this.pattern.matcher(name).matches();
            }
            return false;
        }

        public String toString() {
            return this.expression;
        }
    }

    public static class NamePathSegmentPattern
    extends PathSegmentPattern {
        private final String name;
        private final boolean directory;

        public NamePathSegmentPattern(String name, boolean directory) {
            super(false, false);
            this.name = name;
            this.directory = directory;
        }

        @Override
        public boolean matches(String name, boolean directory) {
            if (this.directory == directory) {
                return this.name.equals(name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AnyPathSegmentPattern
    extends PathSegmentPattern {
        private final boolean directory;

        public AnyPathSegmentPattern(boolean directory) {
            super(true, true);
            this.directory = directory;
        }

        @Override
        public boolean matches(String name, boolean directory) {
            return this.directory == directory;
        }

        public String toString() {
            return "**";
        }
    }

    public static abstract class PathSegmentPattern {
        private final boolean reusable;
        private final boolean optional;

        public PathSegmentPattern(boolean reusable, boolean optional) {
            this.reusable = reusable;
            this.optional = optional;
        }

        public abstract boolean matches(String var1, boolean var2);

        public boolean isReusable() {
            return this.reusable;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

