/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader;

import java.io.File;
import org.metricssampler.config.loader.FileGlob;

public final class FileGlobProcessor {
    private FileGlobProcessor() {
    }

    public static void visitMatching(File dir, String globExpression, MatchingFileVisitor processor) {
        FileGlob glob = new FileGlob(globExpression);
        FileGlobProcessor.processFile(glob, dir, dir, processor);
    }

    private static void processFile(FileGlob glob, File file, File dir, MatchingFileVisitor processor) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileGlobProcessor.processFile(glob, child, dir, processor);
            }
        } else if (glob.matches(file, dir)) {
            processor.visit(file);
        }
    }

    public static interface MatchingFileVisitor {
        public void visit(File var1);
    }
}

