/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.HttpConnectionPoolConfig;
import org.metricssampler.config.SocketOptionsConfig;
import org.metricssampler.config.loader.xbeans.EntryXBean;
import org.metricssampler.config.loader.xbeans.HttpConnectionPoolXBean;
import org.metricssampler.config.loader.xbeans.InputXBean;
import org.metricssampler.config.loader.xbeans.SocketOptionsXBean;
import org.metricssampler.config.loader.xbeans.ValidationUtils;

public abstract class BaseHttpInputXBean
extends InputXBean {
    @XStreamAsAttribute
    private String url;
    @XStreamAsAttribute
    private String username;
    @XStreamAsAttribute
    private String password;
    @XStreamAlias(value="preemptive-auth")
    @XStreamAsAttribute
    private Boolean preemptiveAuth;
    @XStreamAlias(value="socket-options")
    private SocketOptionsXBean socketOptions;
    @XStreamAlias(value="connection-pool")
    private HttpConnectionPoolXBean connectionPool;
    private List<EntryXBean> headers;

    public List<EntryXBean> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<EntryXBean> headers) {
        this.headers = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SocketOptionsXBean getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(SocketOptionsXBean socketOptions) {
        this.socketOptions = socketOptions;
    }

    public HttpConnectionPoolXBean getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(HttpConnectionPoolXBean connectionPool) {
        this.connectionPool = connectionPool;
    }

    @Override
    protected void validate() {
        super.validate();
        ValidationUtils.validUrl(this, "url", this.url);
    }

    protected Map<String, String> getHeadersAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.headers != null) {
            for (EntryXBean entry : this.headers) {
                entry.validate();
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public void setPreemptiveAuth(Boolean preemptiveAuth) {
        this.preemptiveAuth = preemptiveAuth;
    }

    public Boolean getPreemptiveAuth() {
        return this.preemptiveAuth;
    }

    public boolean isPreemptiveAuthEnabled() {
        return this.getPreemptiveAuth() != null ? this.getPreemptiveAuth() : true;
    }

    protected SocketOptionsConfig createSocketOptionsConfig() {
        return this.getSocketOptions() != null ? this.getSocketOptions().toConfig() : null;
    }

    protected HttpConnectionPoolConfig createConnectionPoolConfig() {
        return this.getConnectionPool() != null ? this.getConnectionPool().toConfig() : null;
    }

    protected URL parseUrl() {
        try {
            return new URL(this.getUrl());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid URL: " + e.getMessage());
        }
    }
}

