/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.metricssampler.config.Configuration;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.InputConfig;
import org.metricssampler.config.OutputConfig;
import org.metricssampler.config.SamplerConfig;
import org.metricssampler.config.SelectorConfig;
import org.metricssampler.config.SharedResourceConfig;
import org.metricssampler.config.loader.xbeans.IncludeXBean;
import org.metricssampler.config.loader.xbeans.InputXBean;
import org.metricssampler.config.loader.xbeans.OutputXBean;
import org.metricssampler.config.loader.xbeans.SamplerXBean;
import org.metricssampler.config.loader.xbeans.SelectorGroupXBean;
import org.metricssampler.config.loader.xbeans.SharedResourceXBean;
import org.metricssampler.config.loader.xbeans.TemplatableXBeanUtils;
import org.metricssampler.config.loader.xbeans.VariableXBean;
import org.metricssampler.config.loader.xbeans.XBean;

@XStreamAlias(value="configuration")
public class ConfigurationXBean
extends XBean {
    private List<IncludeXBean> includes;
    private List<InputXBean> inputs;
    private List<OutputXBean> outputs;
    private List<SamplerXBean> samplers;
    private List<VariableXBean> variables;
    @XStreamAlias(value="shared-resources")
    private List<SharedResourceXBean> sharedResources;
    @XStreamAlias(value="selector-groups")
    private List<SelectorGroupXBean> selectorGroups;

    public List<IncludeXBean> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<IncludeXBean> includes) {
        this.includes = includes;
    }

    public List<InputXBean> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputXBean> inputs) {
        this.inputs = inputs;
    }

    public List<OutputXBean> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputXBean> outputs) {
        this.outputs = outputs;
    }

    public List<SamplerXBean> getSamplers() {
        return this.samplers;
    }

    public void setSamplers(List<SamplerXBean> samplers) {
        this.samplers = samplers;
    }

    public List<SelectorGroupXBean> getSelectorGroups() {
        return this.selectorGroups;
    }

    public void setSelectorTemplates(List<SelectorGroupXBean> selectorGroups) {
        this.selectorGroups = selectorGroups;
    }

    public List<VariableXBean> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableXBean> variables) {
        this.variables = variables;
    }

    public List<SharedResourceXBean> getSharedResources() {
        return this.sharedResources;
    }

    public void setSharedResources(List<SharedResourceXBean> sharedResources) {
        this.sharedResources = sharedResources;
    }

    public Configuration toConfig() {
        Map<String, Object> globalVariables = VariableXBean.toMap(this.getVariables());
        Map<String, SharedResourceConfig> sharedResources = this.configureSharedResources(this.getSharedResources());
        Map<String, InputConfig> inputs = this.configureInputs(this.getInputs());
        Map<String, OutputConfig> outputs = this.configureOutputs(this.getOutputs());
        Map<String, List<SelectorConfig>> selectorGroups = this.configureSelectorGroups(this.getSelectorGroups());
        List<SamplerConfig> samplers = this.configureSamplers(this.getSamplers(), inputs, outputs, selectorGroups, globalVariables);
        return new Configuration(inputs.values(), outputs.values(), samplers, globalVariables, sharedResources);
    }

    private Map<String, InputConfig> configureInputs(List<InputXBean> list) {
        LinkedHashMap<String, InputXBean> xbeans = TemplatableXBeanUtils.sortByDependency(list);
        HashMap<String, InputConfig> result = new HashMap<String, InputConfig>();
        for (InputXBean fromItem : xbeans.values()) {
            TemplatableXBeanUtils.applyTemplate(fromItem, xbeans);
            if (!fromItem.isInstantiatable()) continue;
            InputConfig item = fromItem.toConfig();
            if (result.containsKey(item.getName())) {
                throw new ConfigurationException("Two inputs with the same name " + item.getName());
            }
            result.put(item.getName(), item);
        }
        return result;
    }

    private Map<String, OutputConfig> configureOutputs(List<OutputXBean> list) {
        HashMap<String, OutputConfig> result = new HashMap<String, OutputConfig>();
        if (list != null) {
            for (OutputXBean fromItem : list) {
                OutputConfig item = fromItem.toConfig();
                if (result.containsKey(item.getName())) {
                    throw new ConfigurationException("Two outputs with the same name " + item.getName());
                }
                result.put(item.getName(), item);
            }
        }
        return result;
    }

    private Map<String, List<SelectorConfig>> configureSelectorGroups(List<SelectorGroupXBean> items) {
        HashMap<String, SelectorGroupXBean> groups = new HashMap<String, SelectorGroupXBean>(items != null ? items.size() : 0);
        if (items != null) {
            for (SelectorGroupXBean item : items) {
                if (groups.containsKey(item.getName())) {
                    throw new ConfigurationException("Two selector groups with the same name \"" + item.getName() + "\"");
                }
                groups.put(item.getName(), item);
            }
        }
        HashMap<String, List<SelectorConfig>> result = new HashMap<String, List<SelectorConfig>>();
        for (SelectorGroupXBean item : groups.values()) {
            result.put(item.getName(), item.toConfig(groups));
        }
        return result;
    }

    private List<SamplerConfig> configureSamplers(List<SamplerXBean> samplers, Map<String, InputConfig> inputs, Map<String, OutputConfig> outputs, Map<String, List<SelectorConfig>> selectorGroups, Map<String, Object> globalVariables) {
        LinkedHashMap<String, SamplerXBean> namedSamplers = TemplatableXBeanUtils.sortByDependency(samplers);
        LinkedList<SamplerConfig> result = new LinkedList<SamplerConfig>();
        if (samplers != null) {
            for (SamplerXBean def : samplers) {
                TemplatableXBeanUtils.applyTemplate(def, namedSamplers);
                if (!def.isInstantiatable()) continue;
                result.add(def.toConfig(inputs, outputs, selectorGroups, globalVariables));
            }
        }
        return result;
    }

    private Map<String, SharedResourceConfig> configureSharedResources(List<SharedResourceXBean> sharedResources) {
        if (sharedResources == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SharedResourceConfig> result = new HashMap<String, SharedResourceConfig>(sharedResources.size());
        for (SharedResourceXBean item : sharedResources) {
            if (result.containsKey(item.getName())) {
                throw new ConfigurationException("Two shared resources with the same name \"" + item.getName() + "\"");
            }
            result.put(item.getName(), item.toConfig());
        }
        return result;
    }

    public void include(ConfigurationXBean includeConfig) {
        this.inputs = this.addAllToList(this.inputs, includeConfig.getInputs());
        this.outputs = this.addAllToList(this.outputs, includeConfig.getOutputs());
        this.variables = this.addAllToList(this.variables, includeConfig.getVariables());
        this.selectorGroups = this.addAllToList(this.selectorGroups, includeConfig.getSelectorGroups());
        this.samplers = this.addAllToList(this.samplers, includeConfig.getSamplers());
        this.sharedResources = this.addAllToList(this.sharedResources, includeConfig.getSharedResources());
    }

    private <T> List<T> addAllToList(List<T> destination, List<T> source) {
        LinkedList<T> result;
        LinkedList<T> linkedList = result = destination != null ? destination : new LinkedList<T>();
        if (source != null) {
            for (T item : source) {
                result.add(item);
            }
        }
        return result;
    }
}

