/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.metricssampler.config.SharedResourceConfig;
import org.metricssampler.config.ThreadPoolConfig;
import org.metricssampler.config.loader.xbeans.SharedResourceXBean;
import org.metricssampler.config.loader.xbeans.ValidationUtils;

@XStreamAlias(value="thread-pool")
public class SamplerThreadPoolXBean
extends SharedResourceXBean {
    @XStreamAsAttribute
    private Integer size;
    @XStreamAsAttribute
    @XStreamAlias(value="keep-alive-time")
    private Integer keepAliveTime;
    @XStreamAsAttribute
    @XStreamAlias(value="max-size")
    private Integer maxSize;

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Integer keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected void validate() {
        super.validate();
        ValidationUtils.greaterThanZero(this, "size", this.getSize());
    }

    @Override
    protected SharedResourceConfig createConfig() {
        int coreSize = this.getSize();
        int maxSize = this.getMaxSize() != null ? this.getMaxSize() : -1;
        int keepAliveTime = this.getKeepAliveTime() != null ? this.getKeepAliveTime() : -1;
        return new ThreadPoolConfig(this.getName(), this.isIgnored(), coreSize, maxSize, keepAliveTime);
    }
}

