/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.SelectorConfig;
import org.metricssampler.config.loader.xbeans.NamedXBean;
import org.metricssampler.config.loader.xbeans.SelectorGroupRefXBean;
import org.metricssampler.config.loader.xbeans.SelectorXBean;
import org.metricssampler.config.loader.xbeans.SimpleSelectorXBean;

@XStreamAlias(value="selector-group")
public class SelectorGroupXBean
extends NamedXBean {
    @XStreamImplicit
    private List<SelectorXBean> selectors;
    private transient boolean beingResolved = false;
    private transient List<SimpleSelectorXBean> resolvedSimpleSelectors = null;

    public List<SelectorXBean> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<SelectorXBean> selectors) {
        this.selectors = selectors;
    }

    public List<SelectorConfig> toConfig(Map<String, SelectorGroupXBean> groups) {
        this.validate();
        ArrayList<SelectorConfig> result = new ArrayList<SelectorConfig>(this.selectors.size());
        for (SimpleSelectorXBean item : this.getAllSelectors(groups)) {
            result.add(item.toConfig());
        }
        return result;
    }

    private List<SimpleSelectorXBean> getAllSelectors(Map<String, SelectorGroupXBean> groups) {
        if (this.beingResolved) {
            throw new ConfigurationException("Selector group \"" + this.getName() + "\" is part of a dependency cycle");
        }
        if (this.resolvedSimpleSelectors == null) {
            this.beingResolved = true;
            this.resolvedSimpleSelectors = new LinkedList<SimpleSelectorXBean>();
            for (SelectorXBean child : this.selectors) {
                if (child instanceof SelectorGroupRefXBean) {
                    String name = ((SelectorGroupRefXBean)child).getName();
                    SelectorGroupXBean referencedGroup = groups.get(name);
                    if (referencedGroup != null) {
                        this.resolvedSimpleSelectors.addAll(referencedGroup.getAllSelectors(groups));
                        continue;
                    }
                    throw new ConfigurationException("Could not find referenced selector group named \"" + name + "\"");
                }
                if (child instanceof SimpleSelectorXBean) {
                    this.resolvedSimpleSelectors.add((SimpleSelectorXBean)child);
                    continue;
                }
                throw new ConfigurationException("Unsupported selector " + child);
            }
            this.beingResolved = false;
            return this.resolvedSimpleSelectors;
        }
        return this.resolvedSimpleSelectors;
    }
}

