/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.loader.xbeans.NamedXBean;
import org.metricssampler.config.loader.xbeans.TemplatableXBean;

public class TemplatableXBeanUtils {
    public static <T extends TemplatableXBean> LinkedHashMap<String, T> sortByDependency(List<T> list) {
        Map<String, T> map = TemplatableXBeanUtils.createMapByName(list);
        LinkedHashMap result = new LinkedHashMap(map.size());
        if (list != null) {
            for (TemplatableXBean item : list) {
                TemplatableXBeanUtils.addDependency(item, result, map);
            }
        }
        return result;
    }

    private static <T extends TemplatableXBean> void addDependency(T item, LinkedHashMap<String, T> result, Map<String, T> map) {
        if (!result.containsKey(item.getName())) {
            if (item.hasParent()) {
                TemplatableXBean parent = (TemplatableXBean)map.get(item.getParent());
                if (parent == null) {
                    throw new ConfigurationException("Template named \"" + item.getParent() + "\" not found");
                }
                TemplatableXBeanUtils.addDependency(parent, result, map);
            }
            result.put(item.getName(), item);
        }
    }

    public static <T extends NamedXBean> Map<String, T> createMapByName(List<T> list) {
        HashMap<String, NamedXBean> result = new HashMap<String, NamedXBean>(list != null ? list.size() : 0);
        if (list != null) {
            for (NamedXBean item : list) {
                result.put(item.getName(), item);
            }
        }
        return result;
    }

    public static <T extends TemplatableXBean> void applyTemplate(T target, LinkedHashMap<String, T> xbeans) {
        if (!target.hasParent()) {
            return;
        }
        try {
            TemplatableXBean parent = (TemplatableXBean)xbeans.get(target.getParent());
            Map templateProperties = PropertyUtils.describe((Object)parent);
            templateProperties.remove("name");
            templateProperties.remove("template");
            Map targetProperties = PropertyUtils.describe(target);
            for (Map.Entry entry : targetProperties.entrySet()) {
                Object templateValue;
                if (entry.getValue() != null || (templateValue = templateProperties.get(entry.getKey())) == null || !PropertyUtils.isWriteable(target, (String)((String)entry.getKey()))) continue;
                PropertyUtils.setProperty(target, (String)((String)entry.getKey()), templateValue);
            }
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException(e);
        }
    }
}

