/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.loader.xbeans.NamedXBean;
import org.metricssampler.util.StringUtils;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    private static String determineTagNameForBean(Object xbean) {
        XStreamAlias annotation = xbean.getClass().getAnnotation(XStreamAlias.class);
        if (annotation != null) {
            return annotation.value();
        }
        return StringUtils.camelCaseToSplit(xbean.getClass().getSimpleName(), "-");
    }

    private static String determineBeanName(Object xbean) {
        String tag = ValidationUtils.determineTagNameForBean(xbean);
        if (xbean instanceof NamedXBean) {
            return tag + "[" + ((NamedXBean)xbean).getName() + "]";
        }
        return tag;
    }

    public static void notEmpty(Object xbean, String name, String value) {
        if (value == null || value.equals("")) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
    }

    public static void notNull(Object xbean, String name, Object value) {
        if (value == null) {
            throw new ConfigurationException("Element \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
    }

    public static void notEmpty(Object xbean, String name, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
    }

    public static void validUrl(Object xbean, String name, String value) {
        ValidationUtils.notEmpty(xbean, name, value);
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is not a valid URL: " + e.getMessage());
        }
    }

    public static void validPort(Object xbean, String name, Integer value) {
        if (value == null) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
        if (value < 1 || value > 65535) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " with value " + value + " is not a valid port in range [1,65535]");
        }
    }

    public static void greaterThanZero(Object xbean, String name, Integer value) {
        if (value == null) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
        if (value < 1) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " with value " + value + " is not a valid number greater than 0");
        }
    }

    public static void notNegative(Object xbean, String name, Integer value) {
        if (value == null) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " is mandatory");
        }
        if (value < 0) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " with value " + value + " is not a valid number greater than or equal to 0");
        }
    }

    public static void notNegativeOptional(Object xbean, String name, Integer value) {
        if (value != null && value < 0) {
            throw new ConfigurationException("Attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " with value " + value + " is not a valid number greater than or equal to 0");
        }
    }

    public static void validPattern(Object xbean, String name, String value) {
        if (value != null) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                throw new ConfigurationException("Value \"" + value + "\" of attribute \"" + name + "\" of " + ValidationUtils.determineBeanName(xbean) + " must be a valid regular expression but compiling it failed with error: " + e.getMessage(), e);
            }
        }
    }
}

