/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.config.loader.xbeans;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.loader.xbeans.ValidationUtils;
import org.metricssampler.config.loader.xbeans.XBean;

public abstract class VariableXBean
extends XBean {
    @XStreamAsAttribute
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void validate() {
        ValidationUtils.notEmpty((Object)this, "name", this.getName());
    }

    public abstract Object getValue();

    public static Map<String, Object> toMap(List<VariableXBean> variables) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (variables != null) {
            for (VariableXBean variable : variables) {
                variable.validate();
                String variableName = variable.getName();
                if (result.containsKey(variableName)) {
                    throw new ConfigurationException("Two variables with the same name " + variableName);
                }
                result.put(variableName, variable.getValue());
            }
        }
        return result;
    }
}

