/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metricssampler.daemon.commands.ControlCommand;
import org.metricssampler.daemon.commands.ControlCommandFactory;

public class ControlCommandParser {
    private static final String CMD_SHUTDOWN = "shutdown";
    private static final String CMD_STATUS = "status";
    private static final Pattern PATTERN_SAMPLER_ACTION = Pattern.compile("^sampler (.+) (enable|disable|reset|list)$");
    private static final Pattern PATTERN_SAMPLER_ENABLE_FOR_TIMES = Pattern.compile("^sampler (.+) enable for ([0-9]+) times$");
    private static final Pattern PATTERN_SAMPLER_ENABLE_FOR_DURATION = Pattern.compile("^sampler (.+) enable for ([0-9]+) (hour|minute|second)s?$");
    private static final Pattern PATTERN_RESOURCE_ACTION = Pattern.compile("^resource (.+) (start|stop)$");
    private final ControlCommandFactory factory;

    public ControlCommandParser(ControlCommandFactory factory) {
        this.factory = factory;
    }

    public ControlCommand parse(String line) {
        ControlCommand result;
        if (line == null) {
            return null;
        }
        if (line.equals(CMD_SHUTDOWN)) {
            return this.factory.shutdown();
        }
        if (line.equals(CMD_STATUS)) {
            return this.factory.status();
        }
        if (line.startsWith("sampler ")) {
            ControlCommand result2 = this.processSamplerCommand(line);
            if (result2 != null) {
                return result2;
            }
        } else if (line.startsWith("resource ") && (result = this.processResourceCommand(line)) != null) {
            return result;
        }
        return this.factory.invalidSyntax(line, "could not parse command");
    }

    protected ControlCommand processSamplerCommand(String line) {
        Matcher actionMatcher = PATTERN_SAMPLER_ACTION.matcher(line);
        if (actionMatcher.matches()) {
            String name = actionMatcher.group(1);
            String action = actionMatcher.group(2);
            if ("enable".equals(action)) {
                return this.factory.enableSamplerForever(name);
            }
            if ("disable".equals(action)) {
                return this.factory.disableSampler(name);
            }
            if ("reset".equals(action)) {
                return this.factory.resetSampler(name);
            }
            if ("list".equals(action)) {
                System.out.println("LISTING");
                return this.factory.listSampler(name);
            }
            return this.factory.invalidSyntax(line, "Unsupported action \"" + action + "\"");
        }
        Matcher enableForTimesMatcher = PATTERN_SAMPLER_ENABLE_FOR_TIMES.matcher(line);
        if (enableForTimesMatcher.matches()) {
            String name = enableForTimesMatcher.group(1);
            try {
                int times = Integer.parseInt(enableForTimesMatcher.group(2));
                return this.factory.enableSamplerForTimes(name, times);
            }
            catch (NumberFormatException e) {
                return this.factory.invalidSyntax(line, "could not parse repetitions as an integer number");
            }
        }
        Matcher enableForDurationMatcher = PATTERN_SAMPLER_ENABLE_FOR_DURATION.matcher(line);
        if (enableForDurationMatcher.matches()) {
            String name = enableForDurationMatcher.group(1);
            try {
                int duration = Integer.parseInt(enableForDurationMatcher.group(2));
                String unitAsString = (enableForDurationMatcher.group(3) + "s").toUpperCase();
                try {
                    TimeUnit unit = TimeUnit.valueOf(unitAsString);
                    long seconds = unit.toSeconds(duration);
                    return this.factory.enableSamplerForDuration(name, seconds);
                }
                catch (IllegalArgumentException e) {
                    return this.factory.invalidSyntax(line, "time unit \"" + unitAsString + "\" is not supported");
                }
            }
            catch (NumberFormatException e) {
                return this.factory.invalidSyntax(line, "could not interpret repetitions as an integer number");
            }
        }
        return null;
    }

    protected ControlCommand processResourceCommand(String line) {
        Matcher actionMatcher = PATTERN_RESOURCE_ACTION.matcher(line);
        if (actionMatcher.matches()) {
            String name = actionMatcher.group(1);
            String action = actionMatcher.group(2);
            if ("start".equals(action)) {
                return this.factory.startResource(name);
            }
            if ("stop".equals(action)) {
                return this.factory.stopResource(name);
            }
            return this.factory.invalidSyntax(line, "Unsupported action \"" + action + "\"");
        }
        return null;
    }
}

