/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon;

import java.util.HashMap;
import java.util.Map;
import org.metricssampler.config.SamplerConfig;
import org.metricssampler.daemon.DefaultTCPController;
import org.metricssampler.resources.SamplerTask;
import org.metricssampler.resources.SamplerThreadPool;
import org.metricssampler.sampler.Sampler;
import org.metricssampler.service.Bootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daemon {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Bootstrapper bootstrapper;
    private Thread controllerThread;
    private final Map<String, SamplerTask> tasks = new HashMap<String, SamplerTask>();

    public Daemon(Bootstrapper bootstrapper) {
        this.bootstrapper = bootstrapper;
    }

    public void start() {
        this.createController();
        this.scheduleSamplers();
        this.controllerThread.start();
    }

    private void createController() {
        try {
            DefaultTCPController controller = new DefaultTCPController(this.bootstrapper, this.tasks, this.bootstrapper.getSharedResources());
            this.controllerThread = new Thread(controller);
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private void scheduleSamplers() {
        for (Sampler sampler : this.bootstrapper.getSamplers()) {
            SamplerConfig config = sampler.getConfig();
            this.logger.info("Scheduling {} at fixed rate of {} seconds", (Object)sampler, (Object)config.getInterval());
            SamplerThreadPool threadPool = (SamplerThreadPool)this.bootstrapper.getSharedResource(sampler.getConfig().getPool());
            SamplerTask task = threadPool.schedule(sampler);
            this.tasks.put(config.getName(), task);
        }
    }
}

