/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.metricssampler.daemon.ControlCommandParser;
import org.metricssampler.daemon.TCPController;
import org.metricssampler.daemon.commands.ControlCommand;
import org.metricssampler.daemon.commands.DefaultControlCommandFactory;
import org.metricssampler.resources.SamplerTask;
import org.metricssampler.resources.SharedResource;
import org.metricssampler.service.Bootstrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTCPController
implements TCPController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerSocket serverSocket;
    private final Bootstrapper bootstrapper;
    private final Map<String, SamplerTask> tasks;
    private final Map<String, SharedResource> sharedResources;
    private BufferedReader clientReader = null;
    private BufferedWriter clientWriter = null;
    private final ControlCommandParser commandParser;

    public DefaultTCPController(Bootstrapper bootstrapper, Map<String, SamplerTask> tasks, Map<String, SharedResource> sharedResources) {
        this.bootstrapper = bootstrapper;
        this.tasks = tasks;
        this.sharedResources = sharedResources;
        this.serverSocket = this.createServerSocket();
        this.commandParser = new ControlCommandParser(new DefaultControlCommandFactory(this));
    }

    @Override
    public Bootstrapper getBootstrapper() {
        return this.bootstrapper;
    }

    @Override
    public Map<String, SamplerTask> getTasks() {
        return this.tasks;
    }

    @Override
    public Map<String, SharedResource> getSharedResources() {
        return this.sharedResources;
    }

    private ServerSocket createServerSocket() {
        String host = this.bootstrapper.getControlHost();
        int port = this.bootstrapper.getControlPort();
        try {
            ServerSocket result = new ServerSocket();
            InetSocketAddress endpoint = new InetSocketAddress(host, port);
            result.bind(endpoint);
            this.logger.info("Bound control endpoint at {}:{}", (Object)host, (Object)port);
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to bind control endpoint at " + host + ":" + port, e);
        }
    }

    @Override
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                this.clientReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.clientWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                String line = this.clientReader.readLine();
                if (line != null) {
                    ControlCommand command = this.commandParser.parse(line);
                    command.execute();
                }
                this.clientReader.close();
                this.clientWriter.close();
                this.clientWriter = null;
                socket.close();
                continue;
            }
            catch (IOException e) {
                this.logger.warn("Failed to accept connection from client", (Throwable)e);
                IOUtils.closeQuietly((Reader)this.clientReader);
                IOUtils.closeQuietly((Writer)this.clientWriter);
                IOUtils.closeQuietly((Socket)socket);
                continue;
            }
            break;
        }
    }

    @Override
    public BufferedReader getClientReader() {
        return this.clientReader;
    }

    @Override
    public BufferedWriter getClientWriter() {
        return this.clientWriter;
    }
}

