/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon.commands;

import org.metricssampler.daemon.TCPController;
import org.metricssampler.daemon.commands.ControlCommand;
import org.metricssampler.daemon.commands.ControlCommandFactory;
import org.metricssampler.daemon.commands.DisableSamplerControlCommand;
import org.metricssampler.daemon.commands.EnableSamplerCommand;
import org.metricssampler.daemon.commands.InvalidSyntaxCommand;
import org.metricssampler.daemon.commands.ListSamplerCommand;
import org.metricssampler.daemon.commands.ResetSamplerControlCommand;
import org.metricssampler.daemon.commands.ShutdownCommand;
import org.metricssampler.daemon.commands.StartResourceCommand;
import org.metricssampler.daemon.commands.StatusCommand;
import org.metricssampler.daemon.commands.StopResourceCommand;

public class DefaultControlCommandFactory
implements ControlCommandFactory {
    private final TCPController controller;

    public DefaultControlCommandFactory(TCPController controller) {
        this.controller = controller;
    }

    @Override
    public StatusCommand status() {
        return new StatusCommand(this.controller.getClientReader(), this.controller.getClientWriter());
    }

    @Override
    public ShutdownCommand shutdown() {
        return new ShutdownCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getBootstrapper());
    }

    @Override
    public DisableSamplerControlCommand disableSampler(String name) {
        return new DisableSamplerControlCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name);
    }

    @Override
    public ResetSamplerControlCommand resetSampler(String name) {
        return new ResetSamplerControlCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name);
    }

    @Override
    public EnableSamplerCommand enableSamplerForever(String name) {
        return new EnableSamplerCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name, -1, -1L);
    }

    @Override
    public EnableSamplerCommand enableSamplerForTimes(String name, int times) {
        return new EnableSamplerCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name, times, -1L);
    }

    @Override
    public EnableSamplerCommand enableSamplerForDuration(String name, long seconds) {
        return new EnableSamplerCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name, -1, seconds);
    }

    @Override
    public InvalidSyntaxCommand invalidSyntax(String line, String msg) {
        return new InvalidSyntaxCommand(this.controller.getClientReader(), this.controller.getClientWriter(), line, msg);
    }

    @Override
    public ControlCommand startResource(String name) {
        return new StartResourceCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getSharedResources(), name);
    }

    @Override
    public ControlCommand stopResource(String name) {
        return new StopResourceCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getSharedResources(), name);
    }

    @Override
    public ControlCommand listSampler(String name) {
        return new ListSamplerCommand(this.controller.getClientReader(), this.controller.getClientWriter(), this.controller.getTasks(), name);
    }
}

