/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.metricssampler.daemon.commands.MapEntryCommand;
import org.metricssampler.resources.SamplerTask;

public class EnableSamplerCommand
extends MapEntryCommand<SamplerTask> {
    private final int times;
    private final long seconds;

    protected EnableSamplerCommand(BufferedReader reader, BufferedWriter writer, Map<String, SamplerTask> tasks, String name, int times, long seconds) {
        super(reader, writer, tasks, name);
        this.times = times;
        this.seconds = seconds;
    }

    @Override
    protected void processMatchingItem(SamplerTask task, BufferedWriter writer) throws IOException {
        if (this.seconds != -1L) {
            this.logger.info("Enabling sampler \"{}\" for {} seconds", (Object)task.getName(), (Object)this.seconds);
            task.enableForDuration(this.seconds);
            this.respond("Sampler \"" + task.getName() + "\" enabled for " + this.seconds + " seconds");
        } else if (this.times == -1) {
            this.logger.info("Enabling sampler \"{}\"", (Object)task.getName(), (Object)this.times);
            task.enable();
            this.respond("Sampler \"" + task.getName() + "\" enabled");
        } else {
            this.logger.info("Enabling sampler \"{}\" for {} samplings", (Object)task.getName(), (Object)this.times);
            task.enableForTimes(this.times);
            this.respond("Sampler \"" + task.getName() + "\" enabled for " + this.times + " times");
        }
    }
}

