/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.daemon.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.metricssampler.daemon.commands.BaseControlCommand;

public abstract class MapEntryCommand<T>
extends BaseControlCommand {
    private final Map<String, T> items;
    private final String name;

    public MapEntryCommand(BufferedReader reader, BufferedWriter writer, Map<String, T> items, String name) {
        super(reader, writer);
        this.items = items;
        this.name = name;
    }

    protected void before() throws IOException {
    }

    protected void after(int count) throws IOException {
    }

    @Override
    public void execute() throws IOException {
        try {
            Pattern nameExpression = Pattern.compile(this.name);
            int matchingItems = 0;
            this.before();
            for (Map.Entry<String, T> entry : this.items.entrySet()) {
                if (!nameExpression.matcher(entry.getKey()).matches()) continue;
                this.logger.debug("Processing item \"{}\" because it matches \"{}\"", (Object)entry.getKey(), (Object)nameExpression);
                this.processMatchingItem(entry.getValue(), this.writer);
                ++matchingItems;
            }
            if (matchingItems == 0) {
                this.respond("No items found matching regular expression \"" + this.name + "\"");
            } else {
                this.after(matchingItems);
            }
        }
        catch (PatternSyntaxException e) {
            this.respond("Could not compile item name regular expression \"" + this.name + "\": " + e.getMessage());
        }
    }

    protected abstract void processMatchingItem(T var1, BufferedWriter var2) throws IOException;
}

