/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.reader;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.metricssampler.config.InputConfig;
import org.metricssampler.config.NamedConfig;
import org.metricssampler.reader.MetricsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsReader<T extends InputConfig>
implements MetricsReader {
    protected static final String CONFIG_VAR_PREFIX = "input";
    protected static final Set<String> IGNORED_CONFIG_PROPERTIES = new HashSet<String>(Arrays.asList("class", "variables"));
    protected final T config;
    protected final Logger logger;
    protected final Logger timingsLogger;
    protected final Map<String, Object> variables;

    protected AbstractMetricsReader(T config) {
        this.config = config;
        this.logger = LoggerFactory.getLogger((String)("reader." + ((NamedConfig)config).getName()));
        this.timingsLogger = LoggerFactory.getLogger((String)"timings.reader");
        this.variables = this.prepareVariables();
    }

    private Map<String, Object> prepareVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(((InputConfig)this.config).getVariables());
        try {
            Map configProperties = BeanUtils.describe(this.config);
            for (Map.Entry entry : configProperties.entrySet()) {
                String name = (String)entry.getKey();
                if (IGNORED_CONFIG_PROPERTIES.contains(name)) continue;
                result.put("input." + name, entry.getValue());
            }
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to introspect configuration bean: " + this.config, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Failed to introspect configuration bean: " + this.config, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.warn("Failed to introspect configuration bean: " + this.config, (Throwable)e);
        }
        this.defineCustomVariables(result);
        return Collections.unmodifiableMap(result);
    }

    protected void defineCustomVariables(Map<String, Object> variables) {
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + ((NamedConfig)this.config).getName() + "]";
    }

    @Override
    public void reset() {
    }
}

