/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.reader;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.metricssampler.config.BaseHttpInputConfig;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.SocketOptionsConfig;
import org.metricssampler.reader.AbstractMetricsReader;
import org.metricssampler.reader.BulkMetricsReader;
import org.metricssampler.reader.MetricReadException;
import org.metricssampler.reader.Metrics;
import org.metricssampler.reader.OpenMetricsReaderException;
import org.metricssampler.service.ApplicationInfo;
import org.metricssampler.util.VariableUtils;

public abstract class BaseHttpMetricsReader<T extends BaseHttpInputConfig>
extends AbstractMetricsReader<T>
implements BulkMetricsReader {
    protected final HttpClient httpClient = this.setupClient();
    protected final HttpContext httpContext = this.setupContext();
    protected Metrics values;
    protected final String userAgent = "metrics-sampler v" + ApplicationInfo.getInstance().getVersion();

    public BaseHttpMetricsReader(T config) {
        super(config);
    }

    protected RequestConfig.Builder setupDefaultRequestConfig() {
        RequestConfig.Builder result = RequestConfig.custom();
        if (((BaseHttpInputConfig)this.config).getSocketOptions() != null) {
            return result.setConnectTimeout(((BaseHttpInputConfig)this.config).getSocketOptions().getConnectTimeout());
        }
        return result;
    }

    protected HttpClientBuilder setupClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultHeaders(Arrays.asList(new BasicHeader("User-Agent", this.userAgent)));
        builder.setDefaultRequestConfig(this.setupDefaultRequestConfig().build());
        if (((BaseHttpInputConfig)this.config).getUsername() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(((BaseHttpInputConfig)this.config).getUsername(), ((BaseHttpInputConfig)this.config).getPassword()));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (((BaseHttpInputConfig)this.config).getSocketOptions() != null) {
            SocketOptionsConfig socketOptions = ((BaseHttpInputConfig)this.config).getSocketOptions();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(socketOptions.getSoTimeout()).setSoKeepAlive(socketOptions.isKeepAlive()).setSndBufSize(socketOptions.getSndBuffSize()).setRcvBufSize(socketOptions.getRcvBuffSize()).build();
            builder.setDefaultSocketConfig(socketConfig);
        }
        if (((BaseHttpInputConfig)this.config).getConnectionPool() != null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager((long)((BaseHttpInputConfig)this.config).getConnectionPool().getTimeToLiveSeconds(), TimeUnit.SECONDS);
            connectionManager.setDefaultMaxPerRoute(((BaseHttpInputConfig)this.config).getConnectionPool().getMaxPerRoute());
            connectionManager.setMaxTotal(((BaseHttpInputConfig)this.config).getConnectionPool().getMaxTotal());
            builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        return builder;
    }

    protected HttpClient setupClient() {
        return this.setupClientBuilder().build();
    }

    protected List<String> getRequestPaths() {
        return Arrays.asList("");
    }

    protected List<HttpUriRequest> setupRequests() {
        List<String> paths = this.getRequestPaths();
        ArrayList<HttpUriRequest> result = new ArrayList<HttpUriRequest>(paths.size());
        for (String path : paths) {
            result.add((HttpUriRequest)this.setupGetRequest(path));
        }
        return result;
    }

    protected HttpGet setupGetRequest(String path) {
        try {
            HttpGet result = new HttpGet(((BaseHttpInputConfig)this.config).getUrl().toURI() + path);
            for (Map.Entry<String, String> header : ((BaseHttpInputConfig)this.config).getHeaders().entrySet()) {
                result.setHeader(header.getKey(), header.getValue());
            }
            return result;
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Failed to convert URL to URI", e);
        }
    }

    protected HttpContext setupContext() {
        BasicHttpContext result = new BasicHttpContext();
        if (((BaseHttpInputConfig)this.config).isPreemptiveAuthEnabled()) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(new HttpHost(((BaseHttpInputConfig)this.config).getUrl().getHost(), ((BaseHttpInputConfig)this.config).getUrl().getPort()), (AuthScheme)basicAuth);
            result.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        return result;
    }

    @Override
    protected void defineCustomVariables(Map<String, Object> variables) {
        VariableUtils.addHostVariables(variables, "input", ((BaseHttpInputConfig)this.config).getUrl().getHost());
    }

    @Override
    public void open() throws MetricReadException {
        long start = System.currentTimeMillis();
        try {
            this.fetchOverHttp(this.httpClient, this.httpContext);
        }
        catch (Exception e) {
            throw new OpenMetricsReaderException(e);
        }
        long end = System.currentTimeMillis();
        this.timingsLogger.debug("Discovered {} metrics in {} ms", (Object)this.values.size(), (Object)(end - start));
    }

    protected void fetchOverHttp(HttpClient httpClient, HttpContext httpContext) throws Exception {
        this.values = new Metrics();
        List<HttpUriRequest> httpRequests = this.setupRequests();
        for (HttpUriRequest httpRequest : httpRequests) {
            this.fetchOverHttp(httpClient, httpContext, httpRequest);
        }
    }

    protected void fetchOverHttp(HttpClient client, HttpContext context, HttpUriRequest request) throws Exception {
        HttpResponse response = client.execute(request, context);
        this.processResponse(request, response);
    }

    protected abstract void processResponse(HttpUriRequest var1, HttpResponse var2) throws Exception;

    protected Charset parseCharset(HttpEntity entity) {
        try {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
            if (contentType != null && contentType.getCharset() != null) {
                return contentType.getCharset();
            }
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse content type", (Throwable)e);
        }
        return Charset.defaultCharset();
    }

    @Override
    public void close() {
    }

    @Override
    public Metrics readAllMetrics() throws MetricReadException {
        return this.values;
    }

    protected InputStreamReader streamEntity(HttpEntity entity) throws IOException {
        Charset charset = this.parseCharset(entity);
        InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
        return reader;
    }
}

