/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.metricssampler.reader.Metric;
import org.metricssampler.reader.MetricName;
import org.metricssampler.reader.MetricValue;
import org.metricssampler.reader.SimpleMetricName;

public class Metrics
implements Iterable<Metric> {
    private final List<Metric> items;

    public Metrics(List<Metric> items) {
        this.items = items;
    }

    public Metrics() {
        this(new ArrayList<Metric>());
    }

    public Metrics(Metric ... metrics) {
        this(Arrays.asList(metrics));
    }

    public void clear() {
        this.items.clear();
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Iterator<Metric> iterator() {
        return this.items.iterator();
    }

    @Override
    public void forEach(Consumer<? super Metric> action) {
        this.items.forEach(action);
    }

    @Override
    public Spliterator<Metric> spliterator() {
        return this.items.spliterator();
    }

    public Set<MetricName> getNames() {
        return this.items.stream().map(Metric::getName).collect(Collectors.toSet());
    }

    public Optional<Metric> get(String name) {
        return this.items.stream().filter(e -> e.getName().getName().equals(name)).findFirst();
    }

    public List<Metric> getAll(String name) {
        return this.items.stream().filter(e -> e.getName().getName().equals(name)).collect(Collectors.toList());
    }

    public void add(Metric metric) {
        this.items.add(metric);
    }

    public void add(String name, String description, MetricValue value) {
        this.add(new Metric(new SimpleMetricName(name, description), value));
    }

    public void add(String name, MetricValue value) {
        this.add(new Metric(new SimpleMetricName(name, null), value));
    }

    public void add(MetricName name, MetricValue value) {
        this.add(new Metric(name, value));
    }

    public void add(MetricName name, long timestamp, Object value) {
        this.add(new Metric(name, new MetricValue(timestamp, value)));
    }

    public void add(String name, long timestamp, Object value) {
        this.add(new Metric(new SimpleMetricName(name, null), new MetricValue(timestamp, value)));
    }

    public void add(String name, String description, long timestamp, Object value) {
        this.add(new Metric(new SimpleMetricName(name, description), new MetricValue(timestamp, value)));
    }

    public void addAll(Metrics metrics) {
        this.items.addAll(metrics.items);
    }
}

