/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.reader;

import org.metricssampler.reader.MetricName;
import org.metricssampler.util.Preconditions;

public class SimpleMetricName
implements MetricName {
    private final String name;
    private final String description;

    public SimpleMetricName(String name, String description) {
        Preconditions.checkArgumentNotNullNorEmpty(name, "name");
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleMetricName that = (SimpleMetricName)obj;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

