/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.resources;

public class SamplerStats {
    private static ThreadLocal<SamplerStats> stats = new ThreadLocal();
    private int sampleSuccessCount = 0;
    private int sampleFailureCount = 0;
    private int connectCount = 0;
    private int disconnectCount = 0;
    private long activationTimestamp = System.currentTimeMillis();
    private long sampleStartTime = 0L;
    private long sampleEndTime = 0L;
    private int metricsCount = 0;

    public static void init() {
        SamplerStats.set(new SamplerStats());
    }

    public static void set(SamplerStats value) {
        stats.set(value);
    }

    public static SamplerStats get() {
        return stats.get();
    }

    public static void unset() {
        stats.remove();
    }

    public void startSample() {
        this.sampleStartTime = System.currentTimeMillis();
    }

    public int getSampleDuration() {
        return (int)((this.sampleEndTime - this.sampleStartTime) / 1000L);
    }

    public void endSample() {
        this.sampleEndTime = System.currentTimeMillis();
    }

    public int getActiveTime() {
        return this.activationTimestamp == -1L ? 0 : (int)((System.currentTimeMillis() - this.activationTimestamp) / 1000L);
    }

    public void activate() {
        this.activationTimestamp = System.currentTimeMillis();
    }

    public void deactivate() {
        this.activationTimestamp = -1L;
    }

    public int getSampleSuccessCount() {
        return this.sampleSuccessCount;
    }

    public void incSampleSuccessCount() {
        ++this.sampleSuccessCount;
    }

    public int getSampleFailureCount() {
        return this.sampleFailureCount;
    }

    public void incSampleFailureCount() {
        ++this.sampleFailureCount;
    }

    public int getConnectCount() {
        return this.connectCount;
    }

    public void incConnectCount() {
        ++this.connectCount;
    }

    public int getDisconnectCount() {
        return this.disconnectCount;
    }

    public void incDisconnectCount() {
        ++this.disconnectCount;
    }

    public int getMetricsCount() {
        return this.metricsCount;
    }

    public void setMetricsCount(int metricsCount) {
        this.metricsCount = metricsCount;
    }
}

