/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.resources;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.metricssampler.resources.SamplerStats;
import org.metricssampler.sampler.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SamplerTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Sampler sampler;
    private final SamplerStats stats = new SamplerStats();
    private final Lock repetitionsLock = new ReentrantLock();
    private long repetitions = -1L;

    public SamplerTask(Sampler sampler) {
        this.sampler = sampler;
        if (sampler.getConfig().isDisabled()) {
            this.stats.deactivate();
            this.disable();
        }
    }

    @Override
    public void run() {
        MDC.put((String)"sampler", (String)this.sampler.getConfig().getName());
        SamplerStats.set(this.stats);
        this.repetitionsLock.lock();
        if (this.repetitions != 0L) {
            try {
                this.decrementRemainingRepetitions();
                this.repetitionsLock.unlock();
                this.stats.startSample();
                this.sampler.sample();
                this.stats.endSample();
                this.stats.incSampleSuccessCount();
            }
            catch (RuntimeException e) {
                this.logger.warn("Sampler threw exception. Ignoring.", (Throwable)e);
                this.stats.incSampleFailureCount();
                this.stats.endSample();
            }
        } else {
            this.repetitionsLock.unlock();
            this.logger.debug("Sampler disabled thus not sampling");
        }
        SamplerStats.unset();
        MDC.remove((String)"sampler");
    }

    private void decrementRemainingRepetitions() {
        --this.repetitions;
        if (this.repetitions == Long.MIN_VALUE) {
            this.repetitions = -1L;
        }
        if (this.repetitions == 0L) {
            this.stats.deactivate();
            this.logger.info("Auto-disabling sampler because it reached its repetitions limit");
        }
    }

    public void enable() {
        this.stats.activate();
        this.enableForTimes(-1);
    }

    public void enableForTimes(int times) {
        this.repetitionsLock.lock();
        this.stats.activate();
        this.repetitions = times;
        this.repetitionsLock.unlock();
    }

    public void enableForDuration(long seconds) {
        long times = seconds / (long)this.sampler.getConfig().getInterval();
        this.repetitionsLock.lock();
        this.stats.activate();
        this.repetitions = times > 1L ? times : 1L;
        this.repetitionsLock.unlock();
    }

    public void disable() {
        this.repetitionsLock.lock();
        this.stats.deactivate();
        this.repetitions = 0L;
        this.repetitionsLock.unlock();
    }

    public void reset() {
        if (this.sampler != null) {
            this.sampler.reset();
        }
    }

    public String getName() {
        return this.sampler.getConfig().getName();
    }

    public SamplerStats getStats() {
        return this.stats;
    }
}

