/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.selector;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.metricssampler.reader.BulkMetricsReader;
import org.metricssampler.reader.MetaDataMetricsReader;
import org.metricssampler.reader.Metric;
import org.metricssampler.reader.MetricName;
import org.metricssampler.reader.MetricReadException;
import org.metricssampler.reader.MetricValue;
import org.metricssampler.reader.Metrics;
import org.metricssampler.reader.MetricsMetaData;
import org.metricssampler.reader.MetricsReader;
import org.metricssampler.selector.MetricsSelector;
import org.metricssampler.selector.SelectedMetric;
import org.metricssampler.selector.VariableReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsSelector
implements MetricsSelector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final VariableReplacer variableReplacer = new VariableReplacer();
    private Map<String, Object> variables;
    private MetricsMetaData cachedMetaData;
    private List<SelectedMetric> cachedSelectedMetrics;

    @Override
    public Metrics readMetrics(MetricsReader reader) {
        if (reader instanceof MetaDataMetricsReader) {
            return this.readAlreadySelected((MetaDataMetricsReader)reader);
        }
        if (reader instanceof BulkMetricsReader) {
            return this.readAllAndSelect((BulkMetricsReader)reader);
        }
        throw new IllegalArgumentException("Unsupported reader: " + reader);
    }

    protected Metrics readAlreadySelected(MetaDataMetricsReader reader) {
        List<SelectedMetric> matchingMetrics = this.getSelectedMetrics(reader);
        Metrics result = new Metrics();
        for (SelectedMetric bean : matchingMetrics) {
            try {
                MetricValue value = reader.readMetric(bean.getOriginalName());
                result.add(bean.getName(), value);
            }
            catch (MetricReadException e) {
                this.logger.warn("Failed to read " + bean.getOriginalName(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<SelectedMetric> getSelectedMetrics(MetaDataMetricsReader reader) {
        MetricsMetaData metaData = reader.getMetaData();
        if (this.cachedMetaData != metaData) {
            this.cachedMetaData = metaData;
            this.cachedSelectedMetrics = this.selectMetrics(metaData);
            if (this.cachedSelectedMetrics.isEmpty()) {
                this.logger.warn(this + " matched no metrics");
            }
        }
        return this.cachedSelectedMetrics;
    }

    protected List<SelectedMetric> selectMetrics(Iterable<MetricName> names) {
        this.logger.debug("Selecting metrics");
        LinkedList<SelectedMetric> result = new LinkedList<SelectedMetric>();
        for (MetricName name : names) {
            SelectedMetric metric = this.selectMetric(name);
            if (metric == null) continue;
            result.add(metric);
        }
        return Collections.unmodifiableList(result);
    }

    protected abstract SelectedMetric selectMetric(MetricName var1);

    protected Metrics readAllAndSelect(BulkMetricsReader reader) {
        Metrics result = new Metrics();
        Metrics metrics = reader.readAllMetrics();
        for (Metric entry : metrics) {
            SelectedMetric metric = this.selectMetric(entry.getName());
            if (metric == null) continue;
            result.add(metric.getName(), entry.getName().getDescription(), entry.getValue());
        }
        return result;
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        this.variables = Collections.unmodifiableMap(VariableReplacer.resolve(variables));
        this.doAfterVariablesSet(variables);
    }

    protected abstract void doAfterVariablesSet(Map<String, Object> var1);

    protected String replaceVariables(String text, Map<String, Object> variables) {
        return this.variableReplacer.replaceVariables(text, variables);
    }

    protected String replaceVariables(String text) {
        return this.replaceVariables(text, this.variables);
    }

    @Override
    public int getMetricCount(MetricsReader reader) {
        Iterable<MetricName> names;
        if (reader instanceof MetaDataMetricsReader) {
            names = ((MetaDataMetricsReader)reader).getMetaData();
        } else if (reader instanceof BulkMetricsReader) {
            names = reader.readNames();
        } else {
            throw new IllegalArgumentException("Unsupported metrics reader: " + reader);
        }
        List<SelectedMetric> matchingMetrics = this.selectMetrics(names);
        return matchingMetrics.size();
    }

    protected void addVariables(Map<String, Object> map) {
        map.putAll(this.variables);
    }

    @Override
    public void reset() {
        this.cachedMetaData = null;
        this.cachedSelectedMetrics = null;
    }
}

