/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.selector;

import java.util.HashMap;
import java.util.Map;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableReplacer {
    public static final String START = "${";
    public static final String END = "}";
    public static final String FUNCTION_PREFIX = "fn:";
    public static final int MAX_RESOLVE_ITERATIONS = 50;
    private static final Logger logger = LoggerFactory.getLogger(VariableReplacer.class);

    public static String replace(String expression, Map<String, Object> replacements) {
        Preconditions.checkArgumentNotNull(expression, "expression");
        return new VariableReplacer().replaceVariables(expression, replacements);
    }

    public static Map<String, Object> resolve(Map<String, Object> variables) {
        int iterations;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(variables);
        boolean containesVariableReferences = true;
        for (iterations = 0; containesVariableReferences && iterations < 50; ++iterations) {
            containesVariableReferences = false;
            for (Map.Entry entry : result.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                String oldValue = (String)entry.getValue();
                if (oldValue == null) {
                    throw new ConfigurationException("Variable \"" + (String)entry.getKey() + "\" has null value");
                }
                if (!VariableReplacer.containsVariableReferences(oldValue)) continue;
                containesVariableReferences = true;
                String newValue = VariableReplacer.replace(oldValue, result);
                if (oldValue.equals(newValue)) continue;
                entry.setValue(newValue);
            }
        }
        if (iterations == 50) {
            logger.warn("Reached the maximal number of iterations while resolving variables. You probably have a variable reference cycle.");
        }
        return result;
    }

    private static boolean containsVariableReferences(String expression) {
        return expression.indexOf(START) >= 0;
    }

    public String replaceVariables(String expression, Map<String, Object> replacements) {
        StringBuilder result = new StringBuilder();
        int prevIdx = 0;
        int idx = expression.indexOf(START);
        while (idx >= 0) {
            result.append(expression.substring(prevIdx, idx));
            prevIdx = idx;
            idx = expression.indexOf(END, idx);
            if (idx >= 0) {
                String variableName = expression.substring(prevIdx + START.length(), idx);
                Object newValue = null;
                newValue = variableName.startsWith(FUNCTION_PREFIX) ? this.processFunction(variableName, replacements) : replacements.get(variableName);
                if (newValue != null) {
                    result.append(newValue);
                } else {
                    result.append(START).append(variableName).append(END);
                }
                prevIdx = idx + END.length();
            } else {
                result.append(expression.substring(idx, 2));
            }
            idx = expression.indexOf(START, idx);
        }
        result.append(expression.substring(prevIdx));
        return result.toString();
    }

    protected Object processFunction(String variableName, Map<String, Object> replacements) {
        int idxLeftPar = variableName.indexOf(40);
        String name = variableName.substring(FUNCTION_PREFIX.length(), idxLeftPar);
        if ("map".equals(name)) {
            int idxRightPar = variableName.indexOf(")", idxLeftPar);
            String paramsSpec = variableName.substring(idxLeftPar + 1, idxRightPar);
            String[] params = paramsSpec.split(",");
            if (params.length == 2) {
                Map dictionary = (Map)replacements.get(params[0]);
                if (dictionary != null) {
                    String key = (String)replacements.get(params[1]);
                    return dictionary.get(key);
                }
                logger.warn("No variable named \"{}\" could be found", (Object)params[0]);
            } else {
                logger.warn("Function map expects 2 parameters not {}", (Object)params.length);
            }
        } else {
            logger.warn("Unknown function: \"{}\"", (Object)name);
        }
        return null;
    }
}

