/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.service;

import org.metricssampler.config.InputConfig;
import org.metricssampler.config.OutputConfig;
import org.metricssampler.config.SamplerConfig;
import org.metricssampler.config.SelectorConfig;
import org.metricssampler.config.SharedResourceConfig;
import org.metricssampler.config.ValueTransformerConfig;
import org.metricssampler.reader.MetricsReader;
import org.metricssampler.resources.SharedResource;
import org.metricssampler.sampler.Sampler;
import org.metricssampler.selector.MetricsSelector;
import org.metricssampler.service.GlobalObjectFactory;
import org.metricssampler.service.LocalObjectFactory;
import org.metricssampler.values.ValueTransformer;
import org.metricssampler.writer.MetricsWriter;

public abstract class AbstractLocalObjectFactory
implements LocalObjectFactory {
    private GlobalObjectFactory globalFactory;

    @Override
    public void setGlobalFactory(GlobalObjectFactory globalFactory) {
        this.globalFactory = globalFactory;
    }

    protected GlobalObjectFactory getGlobalFactory() {
        return this.globalFactory;
    }

    @Override
    public boolean supportsOutput(OutputConfig config) {
        return false;
    }

    @Override
    public final MetricsWriter newWriterForOutput(OutputConfig config) {
        if (!this.supportsOutput(config)) {
            throw new IllegalArgumentException("Unsupported writer config: " + config);
        }
        return this.doNewWriter(config);
    }

    protected MetricsWriter doNewWriter(OutputConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsInput(InputConfig config) {
        return false;
    }

    @Override
    public final MetricsReader newReaderForInput(InputConfig config) {
        if (!this.supportsInput(config)) {
            throw new IllegalArgumentException("Unsupported reader config: " + config);
        }
        return this.doNewReader(config);
    }

    protected MetricsReader doNewReader(InputConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSelector(SelectorConfig config) {
        return false;
    }

    @Override
    public final MetricsSelector newSelector(SelectorConfig config) {
        if (!this.supportsSelector(config)) {
            throw new IllegalArgumentException("Unsupported selector: " + config);
        }
        return this.doNewSelector(config);
    }

    protected MetricsSelector doNewSelector(SelectorConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSampler(SamplerConfig config) {
        return false;
    }

    @Override
    public final Sampler newSampler(SamplerConfig config) {
        if (!this.supportsSampler(config)) {
            throw new IllegalArgumentException("Unsupported sampler config: " + config);
        }
        return this.doNewSampler(config);
    }

    protected Sampler doNewSampler(SamplerConfig config) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SharedResource newSharedResource(SharedResourceConfig config, boolean suspended) {
        if (!this.supportsSharedResource(config)) {
            throw new IllegalArgumentException("Unsupported shared resource config: " + config);
        }
        return this.doNewSharedResource(config, suspended);
    }

    protected SharedResource doNewSharedResource(SharedResourceConfig config, boolean suspended) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsSharedResource(SharedResourceConfig config) {
        return false;
    }

    @Override
    public boolean supportsValueTransformer(ValueTransformerConfig config) {
        return false;
    }

    @Override
    public final ValueTransformer newValueTransformer(ValueTransformerConfig config) {
        if (!this.supportsValueTransformer(config)) {
            throw new IllegalArgumentException("Unsupported shared resource config: " + config);
        }
        return this.doNewValueTransformer(config);
    }

    protected ValueTransformer doNewValueTransformer(ValueTransformerConfig config) {
        throw new UnsupportedOperationException();
    }
}

