/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.util.Preconditions;

public class ApplicationInfo {
    private static final String PROPERTIES_FILE_NAME = "application.info";
    private static ApplicationInfo instance;
    private final String version;

    protected static void initialize() {
        if (instance == null) {
            InputStream propertiesStream = ApplicationInfo.class.getResourceAsStream("application.properties");
            if (propertiesStream == null) {
                throw new ConfigurationException("Could not load application.info from classpath");
            }
            try {
                Properties properties = new Properties();
                properties.load(propertiesStream);
                String version = properties.getProperty("version");
                if (version == null) {
                    throw new ConfigurationException("Could not find version property in application.info");
                }
                instance = new ApplicationInfo(version);
            }
            catch (IOException e) {
                throw new ConfigurationException("Could not load application.info from classpath", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)propertiesStream);
            }
        }
    }

    public static ApplicationInfo getInstance() {
        Preconditions.checkStateNotNull(instance, "instance");
        return instance;
    }

    private ApplicationInfo(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }
}

