/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.metricssampler.config.Configuration;
import org.metricssampler.config.ConfigurationException;
import org.metricssampler.config.InputConfig;
import org.metricssampler.config.OutputConfig;
import org.metricssampler.config.SamplerConfig;
import org.metricssampler.config.SelectorConfig;
import org.metricssampler.config.SharedResourceConfig;
import org.metricssampler.config.ValueTransformerConfig;
import org.metricssampler.config.loader.ConfigurationLoader;
import org.metricssampler.config.loader.XBeanPostProcessor;
import org.metricssampler.config.loader.xbeans.ConfigurationXBean;
import org.metricssampler.config.loader.xbeans.DictionaryVariableXBean;
import org.metricssampler.config.loader.xbeans.EntryXBean;
import org.metricssampler.config.loader.xbeans.HttpConnectionPoolXBean;
import org.metricssampler.config.loader.xbeans.SamplerThreadPoolXBean;
import org.metricssampler.config.loader.xbeans.SelectorGroupRefXBean;
import org.metricssampler.config.loader.xbeans.SelectorGroupXBean;
import org.metricssampler.config.loader.xbeans.SharedResourceXBean;
import org.metricssampler.config.loader.xbeans.StringVariableXBean;
import org.metricssampler.config.loader.xbeans.VariableXBean;
import org.metricssampler.reader.MetricsReader;
import org.metricssampler.resources.SharedResource;
import org.metricssampler.sampler.Sampler;
import org.metricssampler.selector.MetricsSelector;
import org.metricssampler.service.ApplicationInfo;
import org.metricssampler.service.Bootstrapper;
import org.metricssampler.service.Extension;
import org.metricssampler.service.LocalObjectFactory;
import org.metricssampler.values.ValueTransformer;
import org.metricssampler.writer.MetricsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBootstrapper
implements Bootstrapper {
    public static final List<Class<?>> XBEAN_CLASSES = Arrays.asList(ConfigurationXBean.class, SelectorGroupXBean.class, SelectorGroupRefXBean.class, VariableXBean.class, StringVariableXBean.class, DictionaryVariableXBean.class, EntryXBean.class, SharedResourceXBean.class, SamplerThreadPoolXBean.class, HttpConnectionPoolXBean.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Class<?>> xbeanClasses = new ArrayList();
    private final List<LocalObjectFactory> objectFactories = new ArrayList<LocalObjectFactory>();
    private Configuration configuration;
    private List<Sampler> samplers;
    private Map<String, SharedResource> sharedResources;
    private final String controlHost;
    private final int controlPort;
    private List<XBeanPostProcessor> xbeanPostProcessors = new ArrayList<XBeanPostProcessor>();
    private final boolean suspended;

    private DefaultBootstrapper(String controlHost, int controlPort) {
        ApplicationInfo.initialize();
        this.controlHost = controlHost;
        this.controlPort = controlPort;
        this.suspended = false;
    }

    private DefaultBootstrapper(boolean suspended) {
        ApplicationInfo.initialize();
        this.controlHost = null;
        this.controlPort = -1;
        this.suspended = suspended;
    }

    public static Bootstrapper bootstrap(String filename, boolean suspended) {
        DefaultBootstrapper result = new DefaultBootstrapper(suspended);
        result.initialize();
        result.loadConfiguration(filename);
        result.createSharedResources();
        result.createSamplers();
        return result;
    }

    public static Bootstrapper bootstrap(String filename, String controlHost, int controlPort) {
        DefaultBootstrapper result = new DefaultBootstrapper(controlHost, controlPort);
        result.initialize();
        result.loadConfiguration(filename);
        result.createSharedResources();
        result.createSamplers();
        return result;
    }

    public static Bootstrapper bootstrap(String controlHost, int controlPort) {
        return new DefaultBootstrapper(controlHost, controlPort);
    }

    private void initialize() {
        this.xbeanClasses.addAll(XBEAN_CLASSES);
        ServiceLoader<Extension> services = ServiceLoader.load(Extension.class);
        for (Extension extension : services) {
            this.registerExtension(extension);
        }
        Collections.sort(this.xbeanPostProcessors);
    }

    private void loadConfiguration(String filename) {
        this.configuration = ConfigurationLoader.fromFile(filename, this.xbeanClasses, this.xbeanPostProcessors);
    }

    private void createSharedResources() {
        this.logger.debug("Creating shared resources");
        this.sharedResources = new HashMap<String, SharedResource>();
        for (SharedResourceConfig resourceConfig : this.configuration.getSharedResources().values()) {
            if (resourceConfig.isIgnored()) continue;
            SharedResource sharedResource = this.newSharedResource(resourceConfig, this.suspended);
            this.sharedResources.put(resourceConfig.getName(), sharedResource);
        }
        this.logger.debug("Created {} shared resources", (Object)this.sharedResources.size());
    }

    @Override
    public SharedResource newSharedResource(SharedResourceConfig config, boolean suspended) {
        for (LocalObjectFactory factory : this.objectFactories) {
            try {
                if (!factory.supportsSharedResource(config)) continue;
                this.logger.debug("Creating shared resource {}", (Object)config.getName());
                return factory.newSharedResource(config, suspended);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Failed to create shared resource \"" + config.getName() + "\"", e);
            }
        }
        throw new ConfigurationException("Unsupported shared resource named \"" + config.getName() + "\"");
    }

    private void createSamplers() {
        this.logger.debug("Creating samplers");
        this.samplers = new LinkedList<Sampler>();
        for (SamplerConfig samplerConfig : this.configuration.getSamplers()) {
            if (samplerConfig.isIgnored()) continue;
            Sampler sampler = this.newSampler(samplerConfig);
            this.samplers.add(sampler);
        }
    }

    private void registerExtension(Extension extension) {
        this.logger.info("Loading extension {}", (Object)extension.getName());
        extension.initialize();
        this.xbeanClasses.addAll(extension.getXBeans());
        this.xbeanPostProcessors.addAll(extension.getXBeanPostProcessors());
        LocalObjectFactory localObjectFactory = extension.getObjectFactory();
        localObjectFactory.setGlobalFactory(this);
        this.objectFactories.add(localObjectFactory);
    }

    @Override
    public MetricsReader newReaderForInput(InputConfig config) {
        for (LocalObjectFactory factory : this.objectFactories) {
            if (!factory.supportsInput(config)) continue;
            return factory.newReaderForInput(config);
        }
        throw new IllegalArgumentException("Unsupported input: " + config);
    }

    @Override
    public MetricsWriter newWriterForOutput(OutputConfig config) {
        for (LocalObjectFactory factory : this.objectFactories) {
            if (!factory.supportsOutput(config)) continue;
            return factory.newWriterForOutput(config);
        }
        throw new ConfigurationException("Unsupported output: " + config);
    }

    @Override
    public MetricsSelector newSelector(SelectorConfig config) {
        for (LocalObjectFactory factory : this.objectFactories) {
            if (!factory.supportsSelector(config)) continue;
            return factory.newSelector(config);
        }
        throw new ConfigurationException("Unsupported selector: " + config);
    }

    @Override
    public ValueTransformer newValueTransformer(ValueTransformerConfig config) {
        for (LocalObjectFactory factory : this.objectFactories) {
            if (!factory.supportsValueTransformer(config)) continue;
            return factory.newValueTransformer(config);
        }
        throw new ConfigurationException("Unsupported value transformer: " + config);
    }

    @Override
    public Sampler newSampler(SamplerConfig config) {
        for (LocalObjectFactory factory : this.objectFactories) {
            try {
                if (!factory.supportsSampler(config)) continue;
                return factory.newSampler(config);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Failed to create sampler \"" + config.getName() + "\"", e);
            }
        }
        throw new ConfigurationException("Unsupported sampler: " + config);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Iterable<Sampler> getSamplers() {
        return this.samplers;
    }

    @Override
    public String getControlHost() {
        return this.controlHost;
    }

    @Override
    public int getControlPort() {
        return this.controlPort;
    }

    @Override
    public SharedResource getSharedResource(String name) {
        SharedResource result = this.sharedResources.get(name);
        if (result == null) {
            throw new ConfigurationException("Shared resource \"" + name + "\" not found");
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down shared resources");
        for (SharedResource sharedResource : this.sharedResources.values()) {
            sharedResource.shutdown();
        }
    }

    @Override
    public Map<String, SharedResource> getSharedResources() {
        return Collections.unmodifiableMap(this.sharedResources);
    }
}

