/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.metricssampler.resources.SamplerTask;
import org.metricssampler.resources.SharedResource;

public class GlobalRegistry {
    private static GlobalRegistry instance = new GlobalRegistry();
    private final Set<SamplerTask> tasks = new CopyOnWriteArraySet<SamplerTask>();
    private final Set<SharedResource> sharedResources = new HashSet<SharedResource>();

    public static GlobalRegistry getInstance() {
        return instance;
    }

    public void addSamplerTask(SamplerTask task) {
        this.tasks.add(task);
    }

    public Iterable<SamplerTask> getTasks() {
        return this.tasks;
    }

    public Iterable<SharedResource> getSharedResources() {
        return this.sharedResources;
    }

    public void addSharedResource(SharedResource sharedResource) {
        this.sharedResources.add(sharedResource);
    }
}

