/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.util;

import java.util.Collection;
import java.util.Optional;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgumentNotNullNorEmpty(String argument, String name) throws IllegalArgumentException {
        if (argument == null) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be null");
        }
        if (argument.equals("")) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be an empty string");
        }
    }

    public static void checkArgumentNotNull(Object argument, String name) throws IllegalArgumentException {
        if (argument == null) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be null");
        }
    }

    public static void checkArgumentNotNullNorEmpty(Collection<?> argument, String name) throws IllegalArgumentException {
        if (argument == null) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be null");
        }
        if (argument.isEmpty()) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be empty");
        }
    }

    public static void checkArgument(boolean condition, String msg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkStateNull(Object property, String name) throws IllegalArgumentException {
        if (property != null) {
            throw new IllegalStateException("Property \"" + name + "\" must be null");
        }
    }

    public static void checkStateNotNull(Object property, String name) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalStateException("Property \"" + name + "\" may not be null");
        }
    }

    public static void checkArgumentPresent(Optional<?> argument, String name) throws IllegalArgumentException {
        if (!argument.isPresent()) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be null");
        }
    }
}

