/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.metricssampler.config.SocketOptionsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtils {
    private static final Logger logger = LoggerFactory.getLogger(SocketUtils.class);

    private SocketUtils() {
    }

    public static void configureSocketOptions(Socket socket, SocketOptionsConfig options) throws SocketException {
        if (options != null) {
            if (options.isKeepAlive()) {
                socket.setKeepAlive(true);
            }
            if (options.hasSoTimeout()) {
                socket.setSoTimeout(options.getSoTimeout());
            }
            if (options.hasSndBuffSize()) {
                socket.setSendBufferSize(options.getSndBuffSize());
            }
            if (options.hasRcvBuffSize()) {
                socket.setReceiveBufferSize(options.getRcvBuffSize());
            }
        }
    }

    public static Socket createAndConnect(SocketAddress address, SocketOptionsConfig options) throws IOException {
        Socket result = new Socket();
        SocketUtils.configureSocketOptions(result, options);
        logger.debug("Connecting socket");
        if (options != null && options.hasConnectTimeout()) {
            result.connect(address, options.getConnectTimeout());
        } else {
            result.connect(address);
        }
        logger.debug("Socket connected");
        return result;
    }

    public static Socket createAndConnect(String host, int port, SocketOptionsConfig options) throws IOException {
        InetAddress addr = InetAddress.getByName(host);
        InetSocketAddress endpoint = new InetSocketAddress(addr, port);
        return SocketUtils.createAndConnect(endpoint, options);
    }
}

