/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.util;

public final class StringUtils {
    private StringUtils() {
    }

    public static String camelCaseToSplit(String str, String separator) {
        StringBuilder result = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean prevIsUpperCase = false;
        boolean prevIsLowerCase = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            int nextIdx = i + 1;
            boolean thisIsUpperCase = Character.isUpperCase(c);
            boolean nextIsUpperCase = false;
            boolean nextIsLowerCase = false;
            if (nextIdx < chars.length) {
                nextIsUpperCase = Character.isUpperCase(chars[nextIdx]);
                boolean bl = nextIsLowerCase = !nextIsUpperCase;
            }
            if (prevIsLowerCase && thisIsUpperCase || prevIsUpperCase && thisIsUpperCase && nextIsLowerCase) {
                result.append(separator);
            }
            prevIsUpperCase = thisIsUpperCase;
            prevIsLowerCase = !thisIsUpperCase;
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.equals("");
    }

    public static boolean isNotEmptyNorNull(String value) {
        return !StringUtils.isEmptyOrNull(value);
    }

    public static String trim(String value) {
        return value != null ? value.trim() : null;
    }
}

