/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.metricssampler.util.Preconditions;

public final class VariableUtils {
    private VariableUtils() {
    }

    public static void addHostVariables(Map<String, ? super Object> variables, String prefix, String host) {
        Preconditions.checkArgumentNotNull(variables, "variables");
        Preconditions.checkArgumentNotNullNorEmpty(prefix, "prefix");
        if (host != null) {
            variables.put(prefix + ".host", host);
            try {
                InetAddress inetAddress = InetAddress.getByName(host);
                String hostname = inetAddress.getHostName();
                variables.put(prefix + ".fqhn", hostname);
                int dotIdx = hostname.indexOf(46);
                if (dotIdx > 0) {
                    variables.put(prefix + ".hostname", hostname.substring(0, dotIdx));
                } else {
                    variables.put(prefix + ".hostname", hostname);
                }
                variables.put(prefix + ".ip", inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }
}

