/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import com.github.trang.druid.autoconfigure.properties.DruidDataSourceProperties;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.RegexpMethodPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class DruidStatConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidStatConfiguration.class);

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={Filter.class})
    @ConditionalOnProperty(prefix="spring.datasource.druid.web-stat", name={"enabled"}, havingValue="true")
    public static class DruidWebStatConfiguration {
        @Bean
        public FilterRegistrationBean druidWebStatFilter(DruidDataSourceProperties druidProperties) {
            log.debug("druid web-stat-filter init...");
            DruidDataSourceProperties.DruidWebStatProperties properties = druidProperties.getWebStat();
            FilterRegistrationBean registration = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
            registration.addUrlPatterns(new String[]{properties.getUrlPatterns()});
            registration.addInitParameter("exclusions", properties.getExclusions());
            registration.addInitParameter("sessionStatEnable", Boolean.toString(properties.isSessionStatEnable()));
            if (!StringUtils.isEmpty((Object)properties.getSessionStatMaxCount())) {
                registration.addInitParameter("sessionStatMaxCount", Integer.toString(properties.getSessionStatMaxCount()));
            }
            if (!StringUtils.isEmpty((Object)properties.getPrincipalSessionName())) {
                registration.addInitParameter("principalSessionName", properties.getPrincipalSessionName());
            }
            if (!StringUtils.isEmpty((Object)properties.getPrincipalCookieName())) {
                registration.addInitParameter("principalCookieName", properties.getPrincipalCookieName());
            }
            registration.addInitParameter("profileEnable", Boolean.toString(properties.isProfileEnable()));
            return registration;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnProperty(prefix="spring.datasource.druid.aop-stat", name={"enabled"}, havingValue="true")
    public static class DruidAopStatConfiguration {
        @Value(value="${spring.aop.proxy-target-class:false}")
        private boolean proxyTargetClass;

        @Bean
        public DruidStatInterceptor druidStatInterceptor() {
            return new DruidStatInterceptor();
        }

        @Bean
        public RegexpMethodPointcutAdvisor druidStatAdvisor(DruidDataSourceProperties druidProperties, DruidStatInterceptor druidStatInterceptor) {
            DruidDataSourceProperties.DruidAopStatProperties properties = druidProperties.getAopStat();
            return new RegexpMethodPointcutAdvisor(properties.getPatterns(), (Advice)druidStatInterceptor);
        }

        @Bean
        public DefaultAdvisorAutoProxyCreator druidStatProxy() {
            log.debug("druid aop-stat init...");
            DefaultAdvisorAutoProxyCreator druidStatProxyCreator = new DefaultAdvisorAutoProxyCreator();
            druidStatProxyCreator.setProxyTargetClass(this.proxyTargetClass);
            return druidStatProxyCreator;
        }
    }
}

