/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.Solver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.model.typesystem.LazyType;
import com.github.javaparser.resolution.model.typesystem.NullType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.promotion.ConditionalExprHandler;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.symbolsolver.javaparsermodel.DefaultVisitorAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import com.github.javaparser.symbolsolver.resolution.promotion.ConditionalExprResolver;
import com.github.javaparser.symbolsolver.resolution.typeinference.LeastUpperBoundLogic;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Pair;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TypeExtractor
extends DefaultVisitorAdapter {
    private static final String JAVA_LANG_STRING = String.class.getCanonicalName();
    private final ResolvedType stringReferenceType;
    private TypeSolver typeSolver;
    private JavaParserFacade facade;

    public TypeExtractor(TypeSolver typeSolver, JavaParserFacade facade) {
        this.typeSolver = typeSolver;
        this.facade = facade;
        this.stringReferenceType = new LazyType(v -> new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_STRING)));
    }

    @Override
    public ResolvedType visit(VariableDeclarator node, Boolean solveLambdas) {
        if (Navigator.demandParentNode((Node)node) instanceof FieldDeclaration) {
            return this.facade.convertToUsage(node.getType());
        }
        if (Navigator.demandParentNode((Node)node) instanceof VariableDeclarationExpr) {
            return this.facade.convertToUsage(node.getType());
        }
        throw new UnsupportedOperationException(Navigator.demandParentNode((Node)node).getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(Parameter node, Boolean solveLambdas) {
        if (node.getType() instanceof UnknownType) {
            throw new IllegalStateException("Parameter has unknown type: " + node);
        }
        return this.facade.convertToUsage(node.getType());
    }

    @Override
    public ResolvedType visit(ArrayAccessExpr node, Boolean solveLambdas) {
        ResolvedType arrayUsageType = (ResolvedType)node.getName().accept((GenericVisitor)this, (Object)solveLambdas);
        if (arrayUsageType.isArray()) {
            return ((ResolvedArrayType)arrayUsageType).getComponentType();
        }
        return arrayUsageType;
    }

    @Override
    public ResolvedType visit(ArrayCreationExpr node, Boolean solveLambdas) {
        ResolvedType res = this.facade.convertToUsage(node.getElementType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
        for (int i = 0; i < node.getLevels().size(); ++i) {
            res = new ResolvedArrayType(res);
        }
        return res;
    }

    @Override
    public ResolvedType visit(ArrayInitializerExpr node, Boolean solveLambdas) {
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(AssignExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getTarget().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    @Override
    public ResolvedType visit(BinaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MULTIPLY: 
            case REMAINDER: 
            case BINARY_AND: 
            case BINARY_OR: 
            case XOR: {
                return this.facade.getBinaryTypeConcrete((Node)node.getLeft(), (Node)node.getRight(), solveLambdas, node.getOperator());
            }
            case LESS_EQUALS: 
            case LESS: 
            case GREATER: 
            case GREATER_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: 
            case OR: 
            case AND: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case SIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: {
                ResolvedType rt = (ResolvedType)node.getLeft().accept((GenericVisitor)this, (Object)solveLambdas);
                return ResolvedPrimitiveType.unp((ResolvedType)rt);
            }
        }
        throw new UnsupportedOperationException("Operator " + node.getOperator().name());
    }

    @Override
    public ResolvedType visit(CastExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
    }

    @Override
    public ResolvedType visit(ClassExpr node, Boolean solveLambdas) {
        ResolvedType jssType = this.facade.convertToUsage(node.getType());
        return new ReferenceTypeImpl(this.typeSolver.solveType(Class.class.getCanonicalName()), (List)ImmutableList.of((Object)jssType));
    }

    @Override
    public ResolvedType visit(ConditionalExpr node, Boolean solveLambdas) {
        ResolvedType thenExpr = (ResolvedType)node.getThenExpr().accept((GenericVisitor)this, (Object)solveLambdas);
        ResolvedType elseExpr = (ResolvedType)node.getElseExpr().accept((GenericVisitor)this, (Object)solveLambdas);
        ConditionalExprHandler rce = ConditionalExprResolver.getConditionExprHandler(thenExpr, elseExpr);
        try {
            return rce.resolveType();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return (ResolvedType)node.getThenExpr().accept((GenericVisitor)this, (Object)solveLambdas);
        }
    }

    private boolean isCompatible(ResolvedType resolvedType, ResolvedPrimitiveType primitiveType) {
        return resolvedType.isPrimitive() && resolvedType.asPrimitive().equals((Object)primitiveType) || resolvedType.isReferenceType() && resolvedType.asReferenceType().isUnboxableTo(primitiveType);
    }

    @Override
    public ResolvedType visit(EnclosedExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getInner().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    private ResolvedType solveDotExpressionType(ResolvedReferenceTypeDeclaration parentType, FieldAccessExpr node) {
        if (parentType.isEnum() && parentType.asEnum().hasEnumConstant(node.getName().getId())) {
            return parentType.asEnum().getEnumConstant(node.getName().getId()).getType();
        }
        if (parentType.hasField(node.getName().getId())) {
            return parentType.getField(node.getName().getId()).getType();
        }
        if (parentType.hasInternalType(node.getName().getId())) {
            return new ReferenceTypeImpl(parentType.getInternalType(node.getName().getId()));
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(FieldAccessExpr node, Boolean solveLambdas) {
        Optional value;
        block10: {
            SymbolReference sr;
            if (node.getScope() instanceof NameExpr || node.getScope() instanceof FieldAccessExpr) {
                Expression staticValue = node.getScope();
                SymbolReference typeAccessedStatically = JavaParserFactory.getContext((Node)node, this.typeSolver).solveType(staticValue.toString());
                if (typeAccessedStatically.isSolved()) {
                    return this.solveDotExpressionType(((ResolvedTypeDeclaration)typeAccessedStatically.getCorrespondingDeclaration()).asReferenceType(), node);
                }
            } else if (node.getScope() instanceof ThisExpr) {
                ResolvedTypeDeclaration correspondingDeclaration;
                SymbolReference<ResolvedTypeDeclaration> solve = this.facade.solve((ThisExpr)node.getScope());
                if (solve.isSolved() && (correspondingDeclaration = (ResolvedTypeDeclaration)solve.getCorrespondingDeclaration()) instanceof ResolvedReferenceTypeDeclaration) {
                    return this.solveDotExpressionType(correspondingDeclaration.asReferenceType(), node);
                }
            } else if (node.getScope().toString().indexOf(46) > 0 && (sr = this.typeSolver.tryToSolveType(node.getScope().toString())).isSolved()) {
                return this.solveDotExpressionType((ResolvedReferenceTypeDeclaration)sr.getCorrespondingDeclaration(), node);
            }
            value = Optional.empty();
            try {
                value = this.createSolver().solveSymbolAsValue(node.getName().getId(), (Node)node);
            }
            catch (UnsolvedSymbolException use) {
                SymbolReference sref = this.typeSolver.tryToSolveType(node.toString());
                if (!sref.isSolved()) break block10;
                return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)sref.getCorrespondingDeclaration());
            }
        }
        if (value.isPresent()) {
            return ((Value)value.get()).getType();
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(InstanceOfExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(StringLiteralExpr node, Boolean solveLambdas) {
        return this.stringReferenceType;
    }

    @Override
    public ResolvedType visit(IntegerLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.INT;
    }

    @Override
    public ResolvedType visit(LongLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.LONG;
    }

    @Override
    public ResolvedType visit(CharLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.CHAR;
    }

    @Override
    public ResolvedType visit(DoubleLiteralExpr node, Boolean solveLambdas) {
        if (node.getValue().toLowerCase().endsWith("f")) {
            return ResolvedPrimitiveType.FLOAT;
        }
        return ResolvedPrimitiveType.DOUBLE;
    }

    @Override
    public ResolvedType visit(BooleanLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(NullLiteralExpr node, Boolean solveLambdas) {
        return NullType.INSTANCE;
    }

    @Override
    public ResolvedType visit(MethodCallExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on method call %s", (Supplier[])new Supplier[]{() -> node});
        MethodUsage ref = this.facade.solveMethodAsUsage(node);
        Log.trace((String)"getType on method call %s resolved to %s", (Supplier[])new Supplier[]{() -> node, () -> ref});
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> node;
        supplierArray[1] = () -> ((MethodUsage)ref).returnType();
        Log.trace((String)"getType on method call %s return type is %s", (Supplier[])supplierArray);
        return ref.returnType();
    }

    @Override
    public ResolvedType visit(NameExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on name expr %s", (Supplier[])new Supplier[]{() -> node});
        Optional value = this.createSolver().solveSymbolAsValue(node.getName().getId(), (Node)node);
        if (!value.isPresent()) {
            throw new UnsolvedSymbolException("Solving " + node, node.getName().getId());
        }
        return ((Value)value.get()).getType();
    }

    @Override
    public ResolvedType visit(TypeExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on type expr %s", (Supplier[])new Supplier[]{() -> node});
        if (!(node.getType() instanceof ClassOrInterfaceType)) {
            throw new UnsupportedOperationException(node.getType().getClass().getCanonicalName());
        }
        ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)node.getType();
        String nameWithScope = classOrInterfaceType.getNameWithScope();
        SymbolReference typeDeclarationSymbolReference = JavaParserFactory.getContext((Node)classOrInterfaceType, this.typeSolver).solveType(nameWithScope);
        if (typeDeclarationSymbolReference.isSolved()) {
            return new ReferenceTypeImpl(((ResolvedTypeDeclaration)typeDeclarationSymbolReference.getCorrespondingDeclaration()).asReferenceType());
        }
        Optional value = this.createSolver().solveSymbolAsValue(nameWithScope, (Node)node);
        if (value.isPresent()) {
            return ((Value)value.get()).getType();
        }
        throw new UnsolvedSymbolException("Solving " + node, classOrInterfaceType.getName().getId());
    }

    @Override
    public ResolvedType visit(ObjectCreationExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage((Type)node.getType());
    }

    @Override
    public ResolvedType visit(ThisExpr node, Boolean solveLambdas) {
        block3: {
            if (node.getTypeName().isPresent()) {
                String className = ((Name)node.getTypeName().get()).asString();
                try {
                    return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node, className)));
                }
                catch (IllegalStateException e) {
                    Optional cu = node.findAncestor(new Class[]{CompilationUnit.class});
                    SymbolReference clazz = this.typeSolver.tryToSolveType(className);
                    if (!clazz.isSolved()) break block3;
                    return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)clazz.getCorrespondingDeclaration());
                }
            }
        }
        return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node)));
    }

    @Override
    public ResolvedType visit(SuperExpr node, Boolean solveLambdas) {
        if (node.getTypeName().isPresent()) {
            String className = ((Name)node.getTypeName().get()).asString();
            SymbolReference resolvedTypeNameRef = JavaParserFactory.getContext((Node)node, this.typeSolver).solveType(className);
            if (resolvedTypeNameRef.isSolved()) {
                ResolvedTypeDeclaration resolvedTypeName = (ResolvedTypeDeclaration)resolvedTypeNameRef.getCorrespondingDeclaration();
                if (resolvedTypeName.isInterface()) {
                    return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)resolvedTypeName.asInterface());
                }
                if (resolvedTypeName.isClass()) {
                    return (ResolvedType)resolvedTypeName.asClass().getSuperClass().orElseThrow(() -> new RuntimeException("super class unexpectedly empty"));
                }
                throw new UnsupportedOperationException(node.getClass().getCanonicalName());
            }
            throw new UnsolvedSymbolException(className);
        }
        ResolvedReferenceTypeDeclaration typeOfNode = this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node));
        if (typeOfNode instanceof ResolvedClassDeclaration) {
            return (ResolvedType)((ResolvedClassDeclaration)typeOfNode).getSuperClass().orElseThrow(() -> new RuntimeException("super class unexpectedly empty"));
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(UnaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case MINUS: 
            case PLUS: {
                return ResolvedPrimitiveType.unp((ResolvedType)((ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas)));
            }
            case LOGICAL_COMPLEMENT: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: 
            case BITWISE_COMPLEMENT: {
                return (ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas);
            }
        }
        throw new UnsupportedOperationException(node.getOperator().name());
    }

    @Override
    public ResolvedType visit(VariableDeclarationExpr node, Boolean solveLambdas) {
        if (node.getVariables().size() != 1) {
            throw new UnsupportedOperationException();
        }
        return this.facade.convertToUsage(((VariableDeclarator)node.getVariables().get(0)).getType());
    }

    @Override
    public ResolvedType visit(LambdaExpr node, Boolean solveLambdas) {
        Node parentNode = Navigator.demandParentNode((Node)node, (Predicate)Expression.IS_NOT_ENCLOSED_EXPR);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)parentNode;
            int pos = TypeExtractor.getParamPos((Expression)node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(parentNode.toString(), callExpr.getName().getId());
            }
            Log.trace((String)"getType on lambda expr %s", (Supplier[])new Supplier[]{() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName()});
            ResolvedType result = ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
            if (solveLambdas.booleanValue()) {
                if (callExpr.hasScope()) {
                    ResolvedType scopeType;
                    Expression scope = (Expression)callExpr.getScope().get();
                    boolean staticCall = false;
                    if (scope instanceof NameExpr) {
                        NameExpr nameExpr = (NameExpr)scope;
                        try {
                            SymbolReference type = JavaParserFactory.getContext((Node)nameExpr, this.typeSolver).solveType(nameExpr.getName().getId());
                            if (type.isSolved()) {
                                staticCall = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!staticCall && (scopeType = this.facade.getType((Node)scope)).isReferenceType()) {
                        result = scopeType.asReferenceType().useThisTypeParametersOnTheGivenType(result);
                    }
                }
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        if (Navigator.demandParentNode((Node)node) instanceof VariableDeclarator) {
            VariableDeclarator decExpr = (VariableDeclarator)Navigator.demandParentNode((Node)node);
            ResolvedType result = decExpr.getType().resolve();
            if (solveLambdas.booleanValue()) {
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        if (Navigator.demandParentNode((Node)node) instanceof AssignExpr) {
            AssignExpr assExpr = (AssignExpr)Navigator.demandParentNode((Node)node);
            ResolvedType result = assExpr.calculateResolvedType();
            if (solveLambdas.booleanValue()) {
                result = this.resolveLambda(node, result);
            }
            return result;
        }
        throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
    }

    private ResolvedType resolveLambda(LambdaExpr node, ResolvedType result) {
        Context ctx = JavaParserFactory.getContext((Node)node, this.typeSolver);
        Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)(result = result.solveGenericTypes(ctx)));
        if (functionalMethod.isPresent()) {
            ResolvedType actualType;
            LambdaExpr lambdaExpr = node;
            InferenceContext lambdaCtx = new InferenceContext(this.typeSolver);
            InferenceContext funcInterfaceCtx = new InferenceContext(this.typeSolver);
            ResolvedReferenceType functionalInterfaceType = ReferenceTypeImpl.undeterminedParameters((ResolvedReferenceTypeDeclaration)((MethodUsage)functionalMethod.get()).getDeclaration().declaringType());
            lambdaCtx.addPair(result, (ResolvedType)functionalInterfaceType);
            if (lambdaExpr.getBody() instanceof ExpressionStmt) {
                actualType = this.facade.getType((Node)((ExpressionStmt)lambdaExpr.getBody()).getExpression());
            } else if (lambdaExpr.getBody() instanceof BlockStmt) {
                BlockStmt blockStmt = (BlockStmt)lambdaExpr.getBody();
                List returnStmts = blockStmt.findAll(ReturnStmt.class);
                if (returnStmts.size() > 0) {
                    Set<ResolvedType> resolvedTypes = returnStmts.stream().map(returnStmt -> returnStmt.getExpression().map(e -> this.facade.getType((Node)e)).orElse(ResolvedVoidType.INSTANCE)).collect(Collectors.toSet());
                    actualType = LeastUpperBoundLogic.of().lub(resolvedTypes);
                } else {
                    actualType = ResolvedVoidType.INSTANCE;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            ResolvedType formalType = ((MethodUsage)functionalMethod.get()).returnType();
            funcInterfaceCtx.addPair(formalType, actualType);
            ResolvedType functionalTypeWithReturn = funcInterfaceCtx.resolve(funcInterfaceCtx.addSingle((ResolvedType)functionalInterfaceType));
            if (!(formalType instanceof ResolvedVoidType)) {
                lambdaCtx.addPair(result, functionalTypeWithReturn);
                result = lambdaCtx.resolve(lambdaCtx.addSingle(result));
            }
        }
        return result;
    }

    @Override
    public ResolvedType visit(MethodReferenceExpr node, Boolean solveLambdas) {
        if ("new".equals(node.getIdentifier())) {
            return node.getScope().calculateResolvedType();
        }
        Node parentNode = Navigator.demandParentNode((Node)node);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)parentNode;
            int pos = TypeExtractor.getParamPos((Expression)node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr, false);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(parentNode.toString(), callExpr.getName().getId());
            }
            Log.trace((String)"getType on method reference expr %s", (Supplier[])new Supplier[]{() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName()});
            if (solveLambdas.booleanValue()) {
                MethodUsage usage = this.facade.solveMethodAsUsage(callExpr);
                ResolvedType result = usage.getParamType(pos);
                Context ctx = JavaParserFactory.getContext((Node)node, this.typeSolver);
                Optional functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)(result = result.solveGenericTypes(ctx)));
                if (functionalMethodOpt.isPresent()) {
                    MethodUsage functionalMethod = (MethodUsage)functionalMethodOpt.get();
                    for (Pair typeParamDecl : result.asReferenceType().getTypeParametersMap()) {
                        functionalMethod = functionalMethod.replaceTypeParameter((ResolvedTypeParameterDeclaration)typeParamDecl.a, (ResolvedType)typeParamDecl.b);
                    }
                    for (int i = 0; i < functionalMethod.getNoParams(); ++i) {
                        ResolvedType type = functionalMethod.getParamType(i);
                        if (!type.isWildcard()) continue;
                        ResolvedType boundedType = type.asWildcard().getBoundedType();
                        functionalMethod = functionalMethod.replaceParamType(i, boundedType);
                    }
                    ResolvedType actualType = this.facade.toMethodUsage(node, functionalMethod.getParamTypes()).returnType();
                    ResolvedType formalType = functionalMethod.returnType();
                    InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                    inferenceContext.addPair(formalType, actualType);
                    result = inferenceContext.resolve(inferenceContext.addSingle(result));
                }
                return result;
            }
            ResolvedMethodDeclaration rmd = (ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration();
            if (rmd.hasVariadicParameter() && pos >= rmd.getNumberOfParams() - 1) {
                return rmd.getLastParam().getType().asArrayType().getComponentType();
            }
            return rmd.getParam(pos).getType();
        }
        throw new UnsupportedOperationException("The type of a method reference expr depends on the position and its return value");
    }

    @Override
    public ResolvedType visit(FieldDeclaration node, Boolean solveLambdas) {
        if (node.getVariables().size() == 1) {
            return (ResolvedType)((VariableDeclarator)node.getVariables().get(0)).accept((GenericVisitor)this, (Object)solveLambdas);
        }
        throw new IllegalArgumentException("Cannot resolve the type of a field with multiple variable declarations. Pick one");
    }

    private static int getParamPos(Expression node) {
        Node parentNode = Navigator.demandParentNode((Node)node, (Predicate)Expression.IS_NOT_ENCLOSED_EXPR);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr call = (MethodCallExpr)parentNode;
            return call.getArgumentPosition(node, Expression.EXCLUDE_ENCLOSED_EXPR);
        }
        throw new IllegalArgumentException();
    }

    protected Solver createSolver() {
        return new SymbolSolver(this.typeSolver);
    }
}

