/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.XvfbConfig;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.WkhtmltopdfConfigurationException;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.WrapperConfigException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperConfig {
    private static final Logger logger = LoggerFactory.getLogger(WrapperConfig.class);
    private XvfbConfig xvfbConfig;
    private String wkhtmltopdfCommand = "wkhtmltopdf";
    private boolean alwaysPutTocFirst = true;

    @Deprecated
    public WrapperConfig() {
        logger.debug("Initialized with default configurations.");
        this.setWkhtmltopdfCommand(WrapperConfig.findExecutable());
    }

    public WrapperConfig(String wkhtmltopdfCommand) {
        this.setWkhtmltopdfCommand(wkhtmltopdfCommand);
    }

    public static String findExecutable() {
        try {
            String osname = System.getProperty("os.name").toLowerCase();
            String cmd = osname.contains("windows") ? "where.exe wkhtmltopdf" : "which wkhtmltopdf";
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            String text = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset()).trim();
            if (text.isEmpty()) {
                throw new WkhtmltopdfConfigurationException("wkhtmltopdf command was not found in your classpath. Verify its installation or initialize wrapper configurations with correct path/to/wkhtmltopdf");
            }
            logger.debug("Wkhtmltopdf command found in classpath: {}", (Object)text);
            return text;
        }
        catch (IOException | InterruptedException e) {
            logger.error("Fatal:", (Throwable)e);
            throw new WrapperConfigException("Failed while getting wkhtmltopdf executable.", e);
        }
    }

    public String[] getWkhtmltopdfCommandAsArray() {
        return this.wkhtmltopdfCommand.split(" ");
    }

    public void setWkhtmltopdfCommand(String wkhtmltopdfCommand) {
        this.wkhtmltopdfCommand = wkhtmltopdfCommand;
    }

    public boolean isXvfbEnabled() {
        return this.xvfbConfig != null;
    }

    public XvfbConfig getXvfbConfig() {
        return this.xvfbConfig;
    }

    public void setXvfbConfig(XvfbConfig xvfbConfig) {
        this.xvfbConfig = xvfbConfig;
    }

    public void setAlwaysPutTocFirst(boolean alwaysFirst) {
        this.alwaysPutTocFirst = alwaysFirst;
    }

    public boolean getAlwaysPutTocFirst() {
        return this.alwaysPutTocFirst;
    }

    public String toString() {
        return "{xvfbConfig=" + this.xvfbConfig + ", wkhtmltopdfCommand='" + this.wkhtmltopdfCommand + '\'' + '}';
    }
}

