/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.BaseFileStat;
import jnr.posix.NativePOSIX;

public final class AixFileStat
extends BaseFileStat {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    public AixFileStat(NativePOSIX posix) {
        super(posix, layout);
    }

    public long atime() {
        return AixFileStat.layout.st_atime.get(this.memory);
    }

    public long blocks() {
        return AixFileStat.layout.st_blocks.get(this.memory);
    }

    public long blockSize() {
        return AixFileStat.layout.st_blksize.get(this.memory);
    }

    public long ctime() {
        return AixFileStat.layout.st_ctime.get(this.memory);
    }

    public long dev() {
        return AixFileStat.layout.st_dev.get(this.memory);
    }

    public int gid() {
        return (int)AixFileStat.layout.st_gid.get(this.memory);
    }

    public long ino() {
        return AixFileStat.layout.st_ino.get(this.memory);
    }

    public int mode() {
        return (int)AixFileStat.layout.st_mode.get(this.memory) & 0xFFFF;
    }

    public long mtime() {
        return AixFileStat.layout.st_mtime.get(this.memory);
    }

    public int nlink() {
        return AixFileStat.layout.st_nlink.get(this.memory);
    }

    public long rdev() {
        return AixFileStat.layout.st_rdev.get(this.memory);
    }

    public long st_size() {
        return AixFileStat.layout.st_size.get(this.memory);
    }

    public int uid() {
        return (int)AixFileStat.layout.st_uid.get(this.memory);
    }

    private static final class Layout
    extends StructLayout {
        public final StructLayout.Unsigned64 st_dev = new StructLayout.Unsigned64((StructLayout)this);
        public final StructLayout.Signed64 st_ino = new StructLayout.Signed64((StructLayout)this);
        public final StructLayout.Unsigned32 st_mode = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Signed16 st_nlink = new StructLayout.Signed16((StructLayout)this);
        public final StructLayout.Unsigned16 st_flag = new StructLayout.Unsigned16((StructLayout)this);
        public final StructLayout.Unsigned32 st_uid = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Unsigned32 st_gid = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Unsigned64 st_rdev = new StructLayout.Unsigned64((StructLayout)this);
        public final StructLayout.Signed64 st_size = new StructLayout.Signed64((StructLayout)this);
        public final StructLayout.Signed64 st_atime = new StructLayout.Signed64((StructLayout)this);
        public final StructLayout.Signed32 st_atime_n = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Signed32 st_pad1 = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Signed64 st_mtime = new StructLayout.Signed64((StructLayout)this);
        public final StructLayout.Signed32 st_mtime_n = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Signed32 st_pad2 = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Signed64 st_ctime = new StructLayout.Signed64((StructLayout)this);
        public final StructLayout.Signed32 st_ctime_n = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Signed32 st_pad3 = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Unsigned64 st_blksize = new StructLayout.Unsigned64((StructLayout)this);
        public final StructLayout.Unsigned64 st_blocks = new StructLayout.Unsigned64((StructLayout)this);
        public final StructLayout.Signed32 st_vfstype = new StructLayout.Signed32((StructLayout)this);
        public final StructLayout.Unsigned32 st_vfs = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Unsigned32 st_type = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Unsigned32 st_gen = new StructLayout.Unsigned32((StructLayout)this);
        public final StructLayout.Padding st_reserved = new StructLayout.Padding((StructLayout)this, NativeType.UINT, 11);

        private Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

