/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.RequestConvertor;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BaseObjectRequest;
import com.obs.services.model.BaseSnapshotRequest;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.CreateSnapshotRequest;
import com.obs.services.model.CreateSnapshotResponse;
import com.obs.services.model.DeleteSnapshotRequest;
import com.obs.services.model.GetSnapshotListRequest;
import com.obs.services.model.GetSnapshotListResponse;
import com.obs.services.model.GetSnapshottableDirListRequest;
import com.obs.services.model.GetSnapshottableDirListResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.RenameSnapshotRequest;
import com.obs.services.model.RenameSnapshotResponse;
import com.obs.services.model.SetBucketPolicyRequest;
import com.obs.services.model.SetBucketStoragePolicyRequest;
import com.obs.services.model.SetDisallowSnapshotRequest;
import com.obs.services.model.SetSnapshotAllowRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.inventory.DeleteInventoryConfigurationRequest;
import com.obs.services.model.inventory.GetInventoryConfigurationRequest;
import com.obs.services.model.inventory.GetInventoryConfigurationResult;
import com.obs.services.model.inventory.InventoryConfiguration;
import com.obs.services.model.inventory.ListInventoryConfigurationRequest;
import com.obs.services.model.inventory.ListInventoryConfigurationResult;
import com.obs.services.model.inventory.SetInventoryConfigurationRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import okhttp3.Response;

public abstract class ObsBucketBaseService
extends RequestConvertor {
    private static final ILogger log = LoggerBuilder.getLogger(ObsBucketBaseService.class);

    protected ObsBucket createBucketImpl(CreateBucketRequest request) throws ServiceException {
        Response response;
        AccessControlList acl;
        String bucketName;
        block4: {
            AbstractRequestConvertor.TransResult result = this.transCreateBucketRequest(request);
            bucketName = request.getBucketName();
            acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), acl);
            NewTransResult newTransResult = this.transRequestWithResult(result, request);
            response = this.performRequest(newTransResult);
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating bucket with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(bucketName, null, acl, null, false);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set bucket acl error", e);
                }
            }
        }
        ObsBucket bucket = new ObsBucket();
        bucket.setBucketName(bucketName);
        bucket.setLocation(request.getLocation());
        bucket.setAcl(acl);
        bucket.setBucketStorageClass(request.getBucketStorageClass());
        this.setHeadersAndStatus(bucket, response);
        return bucket;
    }

    protected HeaderResponse deleteBucketImpl(BaseBucketRequest request) throws ServiceException {
        Response response = this.performRestDelete(request.getBucketName(), null, null, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected ListBucketsResult listAllBucketsImpl(ListBucketsRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        if (request != null) {
            if (request.isQueryLocation()) {
                this.putHeader(headers, this.getIHeaders("").locationHeader(), "true");
            }
            if (request.getBucketType() != null) {
                this.putHeader(headers, this.getIHeaders("").bucketTypeHeader(), request.getBucketType().getCode());
            }
            if (request.getMaxKeys() > 0) {
                params.put("max-keys", String.valueOf(request.getMaxKeys()));
            }
            if (request.getMarker() != null) {
                params.put("marker", request.getMarker());
            }
        }
        Response httpResponse = this.performRestGetForListBuckets("", null, params, headers);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListBucketsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListBucketsHandler.class, true);
        ListBucketsResult result = new ListBucketsResult(handler.getBuckets(), handler.getOwner(), handler.isTruncated(), handler.getMarker(), handler.getMaxKeys(), handler.getNextMarker());
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected boolean headBucketImpl(BaseBucketRequest request) throws ServiceException {
        try {
            this.performRestHead(request.getBucketName(), null, null, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), null, true);
            return true;
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected GetBucketFSStatusResult getBucketMetadataImpl(BucketMetadataInfoRequest bucketMetadataInfoRequest) throws ServiceException {
        GetBucketFSStatusResult output = null;
        String origin = bucketMetadataInfoRequest.getOrigin();
        List<String> requestHeaders = bucketMetadataInfoRequest.getRequestHeaders();
        if (origin != null && requestHeaders != null && requestHeaders.size() > 0) {
            for (String value : requestHeaders) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Origin", origin);
                headers.put("Access-Control-Request-Headers", value);
                this.transRequestPaymentHeaders(bucketMetadataInfoRequest, headers, this.getIHeaders(bucketMetadataInfoRequest.getBucketName()));
                Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers, bucketMetadataInfoRequest.getUserHeaders(), true);
                if (output == null) {
                    output = this.getOptionInfoResult(bucketMetadataInfoRequest.getBucketName(), response);
                } else {
                    String header = response.header("Access-Control-Allow-Headers");
                    if (header != null && !output.getAllowHeaders().contains(header)) {
                        output.getAllowHeaders().add(header);
                    }
                }
                response.close();
            }
        } else {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (origin != null) {
                headers.put("Origin", origin);
            }
            this.transRequestPaymentHeaders(bucketMetadataInfoRequest, headers, this.getIHeaders(bucketMetadataInfoRequest.getBucketName()));
            Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers, bucketMetadataInfoRequest.getUserHeaders(), true);
            output = this.getOptionInfoResult(bucketMetadataInfoRequest.getBucketName(), response);
            response.close();
        }
        return output;
    }

    protected HeaderResponse setBucketFSStatusImpl(SetBucketFSStatusRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.FILEINTERFACE.getOriginalStringCode(), "");
        HashMap<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        headers = headers == null ? new HashMap<String, String>() : headers;
        String xml = this.getIConvertor(request.getBucketName()).transBucketFileInterface(request.getStatus());
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setHttpMethod(HttpMethodEnum.PUT);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketStoragePolicyConfiguration getBucketStoragePolicyImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(this.getSpecialParamForStorageClass(request.getBucketName()).getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketStoragePolicyConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStoragePolicyHandler.class, false).getStoragePolicy();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketStorageImpl(SetBucketStoragePolicyRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(this.getSpecialParamForStorageClass(request.getBucketName()).getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = request.getBucketStorage() == null ? "" : this.getIConvertor(request.getBucketName()).transStoragePolicy(request.getBucketStorage());
        headers.put("Content-Type", "application/xml");
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketStorageInfo getBucketStorageInfoImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.STORAGEINFO.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketStorageInfo ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStorageInfoHandler.class, false).getStorageInfo();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected BucketLocationResponse getBucketLocationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOCATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketLocationResponse ret = new BucketLocationResponse(this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLocationHandler.class, false).getLocation());
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketPolicyImpl(SetBucketPolicyRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("text/plain", request.getPolicy()));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketPolicyResponse getBucketPolicyImpl(BaseBucketRequest request) throws ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
            Response response = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
            BucketPolicyResponse ret = new BucketPolicyResponse(response.body().string());
            this.setHeadersAndStatus(ret, response);
            return ret;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    protected HeaderResponse deleteBucketPolicyImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected ListVersionsResult listVersionsImpl(ListVersionsRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListVersionsRequest(request);
        Response response = this.performRestGet(request.getBucketName(), null, result.getParams(), result.getHeaders(), request.getUserHeaders());
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.ListVersionsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.ListVersionsHandler.class, true);
        List<VersionOrDeleteMarker> partialItems = handler.getItems();
        ListVersionsResult listVersionsResult = new ListVersionsResult.Builder().bucketName(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName()).prefix(handler.getRequestPrefix() == null ? request.getPrefix() : handler.getRequestPrefix()).keyMarker(handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker()).nextKeyMarker(handler.getNextKeyMarker()).versionIdMarker(handler.getVersionIdMarker() == null ? request.getVersionIdMarker() : handler.getVersionIdMarker()).nextVersionIdMarker(handler.getNextVersionIdMarker()).maxKeys(String.valueOf(handler.getRequestMaxKeys())).isTruncated(handler.isListingTruncated()).versions(partialItems.toArray(new VersionOrDeleteMarker[partialItems.size()])).commonPrefixes(handler.getCommonPrefixes()).location(response.header(this.getIHeaders(request.getBucketName()).bucketRegionHeader())).delimiter(handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter()).builder();
        this.setHeadersAndStatus(listVersionsResult, response);
        return listVersionsResult;
    }

    protected ObjectListing listObjectsImpl(ListObjectsRequest listObjectsRequest) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transListObjectsRequest(listObjectsRequest);
        Response httpResponse = this.performRestGet(listObjectsRequest.getBucketName(), null, result.getParams(), result.getHeaders(), listObjectsRequest.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListObjectsHandler listObjectsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListObjectsHandler.class, true);
        ObjectListing objList = new ObjectListing.Builder().objectSummaries(listObjectsHandler.getObjects()).commonPrefixes(listObjectsHandler.getCommonPrefixes()).bucketName(listObjectsHandler.getBucketName() == null ? listObjectsRequest.getBucketName() : listObjectsHandler.getBucketName()).truncated(listObjectsHandler.isListingTruncated()).prefix(listObjectsHandler.getRequestPrefix() == null ? listObjectsRequest.getPrefix() : listObjectsHandler.getRequestPrefix()).marker(listObjectsHandler.getRequestMarker() == null ? listObjectsRequest.getMarker() : listObjectsHandler.getRequestMarker()).maxKeys(listObjectsHandler.getRequestMaxKeys()).delimiter(listObjectsHandler.getRequestDelimiter() == null ? listObjectsRequest.getDelimiter() : listObjectsHandler.getRequestDelimiter()).nextMarker(listObjectsHandler.getMarkerForNextListing()).location(httpResponse.header(this.getIHeaders(listObjectsRequest.getBucketName()).bucketRegionHeader())).extendCommonPrefixes(listObjectsHandler.getExtendCommonPrefixes()).builder();
        this.setHeadersAndStatus(objList, httpResponse);
        return objList;
    }

    protected BucketMetadataInfoResult optionsImpl(String bucketName, String objectName, OptionsInfoRequest option) throws ServiceException {
        int i;
        IdentityHashMap<String, String> metadata = new IdentityHashMap<String, String>();
        if (ServiceUtils.isValid(option.getOrigin())) {
            metadata.put("Origin", option.getOrigin().trim());
        }
        for (i = 0; option.getRequestMethod() != null && i < option.getRequestMethod().size(); ++i) {
            metadata.put(new String(new StringBuilder("Access-Control-Request-Method")), option.getRequestMethod().get(i));
        }
        for (i = 0; option.getRequestHeaders() != null && i < option.getRequestHeaders().size(); ++i) {
            metadata.put(new String(new StringBuilder("Access-Control-Request-Headers")), option.getRequestHeaders().get(i));
        }
        this.transRequestPaymentHeaders(option.isRequesterPays(), metadata, this.getIHeaders(bucketName));
        Response result = this.performRestOptions(bucketName, objectName, metadata, null, true);
        return this.getOptionInfoResult(bucketName, result);
    }

    protected BucketVersioningConfiguration getBucketVersioningImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(response);
        BucketVersioningConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketVersioningHandler.class, false).getVersioningStatus();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setInventoryConfigurationImpl(SetInventoryConfigurationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.INVENTORY.getOriginalStringCode(), "");
        requestParams.put(SpecialParamEnum.ID.getOriginalStringCode(), request.getInventoryConfiguration().getConfigurationId());
        String xml = this.getIConvertor(request.getBucketName()).transBucketInventoryConfiguration(request.getInventoryConfiguration());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        headers.put("Content-Type", "text/plain");
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("text/plain", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected GetInventoryConfigurationResult getInventoryConfigurationImpl(GetInventoryConfigurationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.INVENTORY.getOriginalStringCode(), "");
        requestParams.put(SpecialParamEnum.ID.getOriginalStringCode(), request.getConfigurationId());
        NewTransResult newTransResult = this.transRequest(request);
        newTransResult.setParams(requestParams);
        Response httpResponse = this.performRequest(newTransResult, true, false, false, false);
        this.verifyResponseContentType(httpResponse);
        GetInventoryConfigurationResult result = new GetInventoryConfigurationResult();
        ArrayList<InventoryConfiguration> configurations = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.InventoryConfigurationsHandler.class, false).getInventoryConfigurations();
        if (configurations == null || configurations.isEmpty()) {
            log.warn("No configuration got, config id is :" + request.getConfigurationId());
        } else {
            result.setInventoryConfiguration((InventoryConfiguration)configurations.get(0));
        }
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected ListInventoryConfigurationResult listInventoryConfigurationImpl(ListInventoryConfigurationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.INVENTORY.getOriginalStringCode(), "");
        NewTransResult newTransResult = this.transRequest(request);
        newTransResult.setParams(requestParams);
        Response httpResponse = this.performRequest(newTransResult, true, false, false, false);
        this.verifyResponseContentType(httpResponse);
        ListInventoryConfigurationResult result = new ListInventoryConfigurationResult();
        ArrayList<InventoryConfiguration> configurations = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.InventoryConfigurationsHandler.class, false).getInventoryConfigurations();
        result.setInventoryConfigurations(configurations);
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteInventoryConfigurationImpl(DeleteInventoryConfigurationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.INVENTORY.getOriginalStringCode(), "");
        requestParams.put(SpecialParamEnum.ID.getOriginalStringCode(), request.getConfigurationId());
        NewTransResult newTransResult = this.transRequest(request);
        newTransResult.setParams(requestParams);
        Response httpResponse = this.performRequest(newTransResult, true, false, false, false);
        return this.build(httpResponse);
    }

    private HeaderResponse processSnapshotRequest(BaseObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.OBS_SNAPSHOT_ROOT.getOriginalStringCode(), "");
        NewTransResult newTransResult = this.transObjectRequest(request);
        newTransResult.setParams(requestParams);
        Response httpResponse = this.performRequest(newTransResult);
        return this.build(httpResponse);
    }

    protected HeaderResponse setSnapshotAllowImpl(SetSnapshotAllowRequest request) throws ServiceException {
        return this.processSnapshotRequest(request);
    }

    protected HeaderResponse setDisallowSnapshotImpl(SetDisallowSnapshotRequest request) throws ServiceException {
        return this.processSnapshotRequest(request);
    }

    protected GetSnapshottableDirListResult getSnapshottableDirListImpl(GetSnapshottableDirListRequest request) throws ServiceException {
        NewTransResult newTransResult = this.transGetSnapshottableDirListRequest(request);
        Response httpResponse = this.performRequest(newTransResult, true, false, false, false);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.GetSnapshottableDirListHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.GetSnapshottableDirListHandler.class, true);
        GetSnapshottableDirListResult getSnapshottableDirListResult = new GetSnapshottableDirListResult(handler.getMarker(), handler.getNextMarker(), handler.isTruncated(), handler.getMaxKeys(), handler.getSnapshottableDirCount(), handler.getSnapshottableDirs());
        this.setHeadersAndStatus(getSnapshottableDirListResult, httpResponse);
        return getSnapshottableDirListResult;
    }

    protected GetSnapshotListResponse getSnapshotListImpl(GetSnapshotListRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.OBS_SNAPSHOT.getOriginalStringCode(), "");
        if (ServiceUtils.isValid(request.getObjectKey())) {
            requestParams.put("objectKey", request.getObjectKey());
        }
        if (ServiceUtils.isValid(request.getMarker())) {
            requestParams.put("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            requestParams.put("max-keys", String.valueOf(request.getMaxKeys()));
        }
        NewTransResult newTransResult = this.transObjectRequest(request);
        newTransResult.setParams(requestParams);
        Response httpResponse = this.performRequest(newTransResult, true, false, false, false);
        XmlResponsesSaxParser.GetSnapshotListHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.GetSnapshotListHandler.class, false);
        GetSnapshotListResponse getSnapshotListResponse = new GetSnapshotListResponse(handler.getMarker(), handler.getNextMarker(), handler.isTruncated(), handler.getMaxKeys(), handler.getSnapshotCount(), handler.getSnapshots());
        this.setHeadersAndStatus(getSnapshotListResponse, httpResponse);
        return getSnapshotListResponse;
    }

    protected RenameSnapshotResponse renameSnapshotImpl(RenameSnapshotRequest request) throws ServiceException {
        String xml;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.OBS_SNAPSHOT.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        headers.put("Content-Type", "application/xml");
        if (request.getOldSnapshotName() == null || request.getNewSnapshotName() == null) {
            log.warn("Snapshot rename operation skipped - missing snapshot names. OldSnapshotName: " + request.getOldSnapshotName() + ", NewSnapshotName: " + request.getNewSnapshotName());
            xml = "";
        } else {
            xml = this.getIConvertor(request.getBucketName()).transRenameSnapshot(request);
        }
        NewTransResult newTransResult = this.transObjectRequest(request);
        newTransResult.setParams(requestParams);
        newTransResult.setHeaders(headers);
        newTransResult.setBody(this.createRequestBody("application/xml", xml));
        Response httpResponse = this.performRequest(newTransResult);
        RenameSnapshotResponse result = new RenameSnapshotResponse();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected CreateSnapshotResponse createSnapshotImpl(CreateSnapshotRequest request) throws ServiceException {
        Response httpResponse = this.executeSnapshotRequest(request);
        CreateSnapshotResponse result = new CreateSnapshotResponse();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteSnapshotImpl(DeleteSnapshotRequest request) throws ServiceException {
        Response httpResponse = this.executeSnapshotRequest(request);
        return this.build(httpResponse);
    }

    private Response executeSnapshotRequest(BaseSnapshotRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.OBS_SNAPSHOT.getOriginalStringCode(), "");
        if (request instanceof CreateSnapshotRequest) {
            requestParams.put("snapshotName", request.getSnapshotName());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        headers.put("Content-Type", "application/xml");
        String xml = this.getIConvertor(request.getBucketName()).transCreateSnapshot(request.getSnapshotName());
        NewTransResult newTransResult = this.transObjectRequest(request);
        newTransResult.setParams(requestParams);
        newTransResult.setHeaders(headers);
        newTransResult.setBody(this.createRequestBody("application/xml", xml));
        return this.performRequest(newTransResult);
    }
}

