/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.io.Serializable;

public abstract class OpenTableLookup
implements Serializable {
    private static final long serialVersionUID = 8381791136767127636L;
    protected int lookupFlag;
    protected int[] subTableLocations;
    protected OpenTypeFontTableReader openReader;

    protected OpenTableLookup(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) {
        this.lookupFlag = lookupFlag;
        this.subTableLocations = subTableLocations;
        this.openReader = openReader;
    }

    public int getLookupFlag() {
        return this.lookupFlag;
    }

    protected void readSubTables() throws IOException {
        for (int subTableLocation : this.subTableLocations) {
            this.readSubTable(subTableLocation);
        }
    }

    protected abstract void readSubTable(int var1) throws IOException;

    public abstract boolean transformOne(GlyphLine var1);

    public boolean transformLine(GlyphLine line) {
        boolean changed = false;
        line.idx = line.start;
        while (line.idx < line.end && line.idx >= line.start) {
            changed = this.transformOne(line) || changed;
        }
        return changed;
    }

    public boolean hasSubstitution(int index) {
        return false;
    }

    public static class GlyphIndexer {
        public GlyphLine line;
        public Glyph glyph;
        public int idx;

        public void nextGlyph(OpenTypeFontTableReader openReader, int lookupFlag) {
            this.glyph = null;
            while (++this.idx < this.line.end) {
                Glyph g = this.line.get(this.idx);
                if (openReader.isSkip(g.getCode(), lookupFlag)) continue;
                this.glyph = g;
                break;
            }
        }

        public void previousGlyph(OpenTypeFontTableReader openReader, int lookupFlag) {
            this.glyph = null;
            while (--this.idx >= this.line.start) {
                Glyph g = this.line.get(this.idx);
                if (openReader.isSkip(g.getCode(), lookupFlag)) continue;
                this.glyph = g;
                break;
            }
        }
    }
}

