/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.InJarFileDataSchemaLocation;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DataSchemaParser {
    private final String _resolverPath;
    private final DataSchemaResolver _schemaResolver;

    public DataSchemaParser(String resolverPath) {
        this._resolverPath = resolverPath;
        this._schemaResolver = CodeUtil.createSchemaResolver(resolverPath);
    }

    public String getResolverPath() {
        return this._resolverPath;
    }

    public DataSchemaResolver getSchemaResolver() {
        return this._schemaResolver;
    }

    public ParseResult parseSources(String[] sources) throws IOException {
        ParseResult result = new ParseResult();
        try {
            for (String source : sources) {
                File sourceFile = new File(source);
                if (sourceFile.exists()) {
                    if (sourceFile.isDirectory()) {
                        FileUtil.FileExtensionFilter filter = new FileUtil.FileExtensionFilter(".pdsc");
                        List sourceFilesInDirectory = FileUtil.listFiles((File)sourceFile, (FileFilter)filter);
                        for (File f : sourceFilesInDirectory) {
                            this.parseFile(f, result);
                            result._sourceFiles.add(f);
                        }
                        continue;
                    }
                    if (sourceFile.getName().endsWith(".jar")) {
                        JarFile jarFile = new JarFile(sourceFile);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.isDirectory() || !entry.getName().endsWith(".pdsc")) continue;
                            this.parseJarEntry(jarFile, entry, result);
                        }
                    } else {
                        this.parseFile(sourceFile, result);
                    }
                    result._sourceFiles.add(sourceFile);
                    continue;
                }
                StringBuilder errorMessage = new StringBuilder();
                NamedDataSchema schema = this._schemaResolver.findDataSchema(source, errorMessage);
                if (schema == null) {
                    result._messageBuilder.append("File cannot be opened or schema name cannot be resolved: ").append(source).append("\n");
                }
                if (errorMessage.length() <= 0) continue;
                result._messageBuilder.append(errorMessage.toString());
            }
            if (result._messageBuilder.length() > 0) {
                throw new IOException(result.getMessage());
            }
            for (Map.Entry entry : this._schemaResolver.nameToDataSchemaLocations().entrySet()) {
                DataSchema schema = (DataSchema)this._schemaResolver.bindings().get(entry.getKey());
                result._schemaAndLocations.put(schema, entry.getValue());
            }
            return result;
        }
        catch (RuntimeException e) {
            if (result._messageBuilder.length() > 0) {
                e = new RuntimeException("Unexpected " + e.getClass().getSimpleName() + " encountered.\n" + "This may be caused by the following parsing or processing errors:\n" + result.getMessage(), e);
            }
            throw e;
        }
    }

    private void parseFile(File schemaSourceFile, ParseResult result) throws IOException {
        DataSchemaLocation location = this.getSchemaLocation(schemaSourceFile);
        if (this._schemaResolver.locationResolved(location)) {
            return;
        }
        SchemaFileInputStream inputStream = new SchemaFileInputStream(schemaSourceFile);
        List<DataSchema> schemas = this.parseSchemaStream(inputStream, location, result);
        for (DataSchema schema : schemas) {
            if (schema instanceof NamedDataSchema) {
                this.validateSchemaWithPath(schemaSourceFile.getAbsolutePath(), (NamedDataSchema)schema);
            }
            result._schemaAndLocations.put(schema, location);
        }
    }

    private void parseJarEntry(JarFile schemaJarFile, JarEntry jarEntry, ParseResult result) throws IOException {
        DataSchemaLocation location = this.getSchemaLocation(schemaJarFile, jarEntry.getName());
        if (this._schemaResolver.locationResolved(location)) {
            return;
        }
        InputStream jarStream = schemaJarFile.getInputStream(jarEntry);
        List<DataSchema> schemas = this.parseSchemaStream(jarStream, location, result);
        for (DataSchema schema : schemas) {
            if (schema instanceof NamedDataSchema) {
                this.validateSchemaWithPath(location.toString(), (NamedDataSchema)schema);
            }
            result._schemaAndLocations.put(schema, location);
        }
    }

    private DataSchemaLocation getSchemaLocation(File schemaFile) {
        return new FileDataSchemaLocation(schemaFile);
    }

    private DataSchemaLocation getSchemaLocation(JarFile jarFile, String pathInJar) {
        return new InJarFileDataSchemaLocation(jarFile, pathInJar);
    }

    private void validateSchemaWithPath(String path, NamedDataSchema namedDataSchema) {
        String namespace = namedDataSchema.getNamespace();
        if (!FileUtil.removeFileExtension((String)path.substring(path.lastIndexOf(File.separator) + 1)).equalsIgnoreCase(namedDataSchema.getName())) {
            throw new IllegalArgumentException(namedDataSchema.getFullName() + " has name that does not match path '" + path + "'");
        }
        String parent = path.substring(0, path.lastIndexOf(File.separator));
        if (!parent.endsWith(namespace.replace('.', File.separatorChar))) {
            throw new IllegalArgumentException(namedDataSchema.getFullName() + " has namespace that does not match " + "parent path '" + parent + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSchema> parseSchemaStream(InputStream schemaInputStream, DataSchemaLocation schemaLocation, ParseResult result) throws IOException {
        SchemaParser parser = new SchemaParser(this._schemaResolver);
        try {
            parser.setLocation(schemaLocation);
            parser.parse(schemaInputStream);
            if (parser.hasError()) {
                List<DataSchema> list = Collections.emptyList();
                return list;
            }
            List list = parser.topLevelDataSchemas();
            return list;
        }
        finally {
            schemaInputStream.close();
            if (parser.hasError()) {
                result._messageBuilder.append(schemaLocation.toString()).append(",").append(parser.errorMessage());
            }
        }
    }

    private static class SchemaFileInputStream
    extends FileInputStream {
        private File _schemaSourceFile;

        private SchemaFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this._schemaSourceFile = file;
        }

        public String toString() {
            return this._schemaSourceFile.toString();
        }
    }

    public static class ParseResult {
        private final Map<DataSchema, DataSchemaLocation> _schemaAndLocations = new HashMap<DataSchema, DataSchemaLocation>();
        private final Set<File> _sourceFiles = new HashSet<File>();
        private final StringBuilder _messageBuilder = new StringBuilder();

        public Map<DataSchema, DataSchemaLocation> getSchemaAndLocations() {
            return this._schemaAndLocations;
        }

        public Set<File> getSourceFiles() {
            return this._sourceFiles;
        }

        public String getMessage() {
            return this._messageBuilder.toString();
        }
    }
}

