/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.template.BooleanArray;
import com.linkedin.data.template.BooleanMap;
import com.linkedin.data.template.BytesArray;
import com.linkedin.data.template.BytesMap;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.DoubleArray;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.FixedTemplate;
import com.linkedin.data.template.FloatArray;
import com.linkedin.data.template.FloatMap;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.IntegerArray;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.LongArray;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.pegasus.generator.CodeUtil;
import com.linkedin.pegasus.generator.JavaCodeGeneratorBase;
import com.linkedin.pegasus.generator.JavaCodeUtil;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.ClassTemplateSpec;
import com.linkedin.pegasus.generator.spec.CustomInfoSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.FixedTemplateSpec;
import com.linkedin.pegasus.generator.spec.MapTemplateSpec;
import com.linkedin.pegasus.generator.spec.ModifierSpec;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDataTemplateGenerator
extends JavaCodeGeneratorBase {
    public static final Map<DataSchema, Class<?>> PredefinedJavaClasses;
    private static final int MAX_SCHEMA_FIELD_JSON_LENGTH = 32000;
    private static final Logger _log;
    private static final String DEPRECATED_KEY = "deprecated";
    private static final String DEPRECATED_SYMBOLS_KEY = "deprecatedSymbols";
    private final Map<ClassTemplateSpec, JDefinedClass> _definedClasses = new HashMap<ClassTemplateSpec, JDefinedClass>();
    private final Map<JDefinedClass, ClassTemplateSpec> _generatedClasses = new HashMap<JDefinedClass, ClassTemplateSpec>();
    private final JClass _recordBaseClass = this.getCodeModel().ref(RecordTemplate.class);
    private final JClass _unionBaseClass = this.getCodeModel().ref(UnionTemplate.class);
    private final JClass _wrappingArrayBaseClass = this.getCodeModel().ref(WrappingArrayTemplate.class);
    private final JClass _wrappingMapBaseClass = this.getCodeModel().ref(WrappingMapTemplate.class);
    private final JClass _directArrayBaseClass = this.getCodeModel().ref(DirectArrayTemplate.class);
    private final JClass _directMapBaseClass = this.getCodeModel().ref(DirectMapTemplate.class);
    private final boolean _recordFieldAccessorWithMode;
    private final boolean _recordFieldRemove;
    private final boolean _pathSpecMethods;
    private final boolean _copierMethods;

    private JavaDataTemplateGenerator(String defaultPackage, boolean recordFieldAccessorWithMode, boolean recordFieldRemove, boolean pathSpecMethods, boolean copierMethods) {
        super(defaultPackage);
        this._recordFieldAccessorWithMode = recordFieldAccessorWithMode;
        this._recordFieldRemove = recordFieldRemove;
        this._pathSpecMethods = pathSpecMethods;
        this._copierMethods = copierMethods;
    }

    public JavaDataTemplateGenerator(Config config) {
        this(config.getDefaultPackage(), config.getRecordFieldAccessorWithMode(), config.getRecordFieldRemove(), config.getPathSpecMethods(), config.getCopierMethods());
    }

    public JavaDataTemplateGenerator(String defaultPackage) {
        this(defaultPackage, true, true, true, true);
    }

    public Map<JDefinedClass, ClassTemplateSpec> getGeneratedClasses() {
        return this._generatedClasses;
    }

    public JClass generate(ClassTemplateSpec classTemplateSpec) {
        JClass result;
        if (classTemplateSpec == null) {
            result = null;
        } else if (classTemplateSpec.getSchema() == null) {
            result = this.getCodeModel().directClass(classTemplateSpec.getFullName());
        } else if (PredefinedJavaClasses.containsKey(classTemplateSpec.getSchema())) {
            Class<?> nativeJavaClass = PredefinedJavaClasses.get(classTemplateSpec.getSchema());
            result = this.getCodeModel().ref(nativeJavaClass);
        } else if (classTemplateSpec.getSchema().isPrimitive()) {
            result = this.generatePrimitive((PrimitiveTemplateSpec)classTemplateSpec);
        } else {
            try {
                JDefinedClass definedClass = this.defineClass(classTemplateSpec);
                this.populateClassContent(classTemplateSpec, definedClass);
                result = definedClass;
            }
            catch (JClassAlreadyExistsException e) {
                throw new IllegalArgumentException(classTemplateSpec.getFullName());
            }
        }
        return result;
    }

    private static JInvocation dataClassArg(JInvocation inv, JClass dataClass) {
        if (dataClass != null) {
            inv.arg(JExpr.dotclass((JClass)dataClass));
        }
        return inv;
    }

    private static void generateCopierMethods(JDefinedClass templateClass) {
        JavaDataTemplateGenerator.overrideCopierMethod(templateClass, "clone");
        JavaDataTemplateGenerator.overrideCopierMethod(templateClass, "copy");
    }

    private static boolean hasNestedFields(DataSchema schema) {
        block6: while (true) {
            switch (schema.getDereferencedType()) {
                case RECORD: {
                    return true;
                }
                case UNION: {
                    return true;
                }
                case ARRAY: {
                    schema = ((ArrayDataSchema)schema.getDereferencedDataSchema()).getItems();
                    continue block6;
                }
                case MAP: {
                    schema = ((MapDataSchema)schema.getDereferencedDataSchema()).getValues();
                    continue block6;
                }
            }
            break;
        }
        return false;
    }

    private static void generateConstructorWithNoArg(JDefinedClass cls, JVar schemaField, JClass newClass) {
        JMethod noArgConstructor = cls.constructor(1);
        noArgConstructor.body().invoke("super").arg((JExpression)JExpr._new((JClass)newClass)).arg((JExpression)schemaField);
    }

    private static void generateConstructorWithNoArg(JDefinedClass cls, JClass newClass) {
        JMethod noArgConstructor = cls.constructor(1);
        noArgConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)newClass));
    }

    private static void generateConstructorWithObjectArg(JDefinedClass cls, JVar schemaField) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param(Object.class, "data");
        argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
    }

    private static void generateConstructorWithArg(JDefinedClass cls, JVar schemaField, JClass paramClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param((JType)paramClass, "data");
        argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
    }

    private static void generateConstructorWithArg(JDefinedClass cls, JVar schemaField, JClass paramClass, JClass elementClass, JClass dataClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar param = argConstructor.param((JType)paramClass, "data");
        JInvocation inv = argConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField).arg(JExpr.dotclass((JClass)elementClass));
        JavaDataTemplateGenerator.dataClassArg(inv, dataClass);
    }

    private static DataSchema schemaForArrayItemsOrMapValues(CustomInfoSpec customInfo, DataSchema schema) {
        return customInfo != null ? customInfo.getCustomSchema() : schema.getDereferencedDataSchema();
    }

    private static void overrideCopierMethod(JDefinedClass templateClass, String methodName) {
        JMethod copierMethod = templateClass.method(1, (JType)templateClass, methodName);
        copierMethod.annotate(Override.class);
        copierMethod._throws(CloneNotSupportedException.class);
        copierMethod.body()._return((JExpression)JExpr.cast((JType)templateClass, (JExpression)JExpr._super().invoke(methodName)));
    }

    private static void setDeprecatedAnnotationAndJavadoc(DataSchema schema, JDefinedClass schemaClass) {
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(schema.getProperties().get(DEPRECATED_KEY), (JAnnotatable)schemaClass, (JDocCommentable)schemaClass);
    }

    private static void setDeprecatedAnnotationAndJavadoc(JMethod method, RecordDataSchema.Field field) {
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(field.getProperties().get(DEPRECATED_KEY), (JAnnotatable)method, (JDocCommentable)method);
    }

    private static void setDeprecatedAnnotationAndJavadoc(EnumDataSchema enumSchema, String symbol, JEnumConstant constant) {
        Object deprecatedSymbolsProp = enumSchema.getProperties().get(DEPRECATED_SYMBOLS_KEY);
        if (deprecatedSymbolsProp instanceof DataMap) {
            DataMap deprecatedSymbols = (DataMap)deprecatedSymbolsProp;
            Object deprecatedProp = deprecatedSymbols.get((Object)symbol);
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(deprecatedProp, (JAnnotatable)constant, (JDocCommentable)constant);
        }
    }

    private static void setDeprecatedAnnotationAndJavadoc(Object deprecatedProp, JAnnotatable annotatable, JDocCommentable commentable) {
        if (Boolean.TRUE.equals(deprecatedProp) && annotatable != null) {
            annotatable.annotate(Deprecated.class);
        } else if (deprecatedProp instanceof String) {
            if (commentable != null) {
                String deprecatedReason = (String)deprecatedProp;
                commentable.javadoc().addDeprecated().append((Object)deprecatedReason);
            }
            if (annotatable != null) {
                annotatable.annotate(Deprecated.class);
            }
        }
    }

    private static int getJModValue(Set<ModifierSpec> modifiers) {
        try {
            int value = 0;
            for (ModifierSpec mod : modifiers) {
                value |= JMod.class.getDeclaredField(mod.name()).getInt(null);
            }
            return value;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addAccessorDoc(JClass clazz, JMethod method, RecordDataSchema.Field field, String prefix) {
        method.javadoc().append((Object)(prefix + " for " + field.getName()));
        method.javadoc().addXdoclet("see " + clazz.name() + ".Fields#" + JavaDataTemplateGenerator.escapeReserved(field.getName()));
    }

    private JDefinedClass defineClass(ClassTemplateSpec classTemplateSpec) throws JClassAlreadyExistsException {
        JDefinedClass result = this._definedClasses.get(classTemplateSpec);
        if (result == null) {
            int jmodValue = JavaDataTemplateGenerator.getJModValue(classTemplateSpec.getModifiers());
            Object container = classTemplateSpec.getEnclosingClass() == null ? this.getPackage(classTemplateSpec.getNamespace()) : this.defineClass(classTemplateSpec.getEnclosingClass());
            if (classTemplateSpec instanceof ArrayTemplateSpec || classTemplateSpec instanceof FixedTemplateSpec || classTemplateSpec instanceof MapTemplateSpec || classTemplateSpec instanceof RecordTemplateSpec || classTemplateSpec instanceof TyperefTemplateSpec || classTemplateSpec instanceof UnionTemplateSpec) {
                result = container._class(jmodValue, JavaDataTemplateGenerator.escapeReserved(classTemplateSpec.getClassName()));
            } else if (classTemplateSpec instanceof EnumTemplateSpec) {
                result = container._class(jmodValue, JavaDataTemplateGenerator.escapeReserved(classTemplateSpec.getClassName()), ClassType.ENUM);
            } else {
                throw new RuntimeException();
            }
            this._definedClasses.put(classTemplateSpec, result);
        }
        return result;
    }

    protected void generateArray(JDefinedClass arrayClass, ArrayTemplateSpec arrayDataTemplateSpec) throws JClassAlreadyExistsException {
        JClass itemJClass = this.generate(arrayDataTemplateSpec.getItemClass());
        JClass dataJClass = this.generate(arrayDataTemplateSpec.getItemDataClass());
        if (CodeUtil.isDirectType(arrayDataTemplateSpec.getSchema().getItems())) {
            arrayClass._extends(this._directArrayBaseClass.narrow(itemJClass));
        } else {
            this.extendWrappingArrayBaseClass(itemJClass, arrayClass);
        }
        ArrayDataSchema bareSchema = new ArrayDataSchema(JavaDataTemplateGenerator.schemaForArrayItemsOrMapValues(arrayDataTemplateSpec.getCustomInfo(), arrayDataTemplateSpec.getSchema().getItems()));
        JFieldVar schemaField = this.generateSchemaField(arrayClass, (DataSchema)bareSchema);
        JavaDataTemplateGenerator.generateConstructorWithNoArg(arrayClass, this._dataListClass);
        this.generateConstructorWithInitialCapacity(arrayClass, this._dataListClass);
        this.generateConstructorWithCollection(arrayClass, itemJClass);
        JavaDataTemplateGenerator.generateConstructorWithArg(arrayClass, (JVar)schemaField, this._dataListClass, itemJClass, dataJClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForCollection(arrayClass, (DataSchema)arrayDataTemplateSpec.getSchema(), itemJClass, "items");
        }
        this.generateCustomClassInitialization(arrayClass, arrayDataTemplateSpec.getCustomInfo());
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(arrayClass);
        }
    }

    protected void extendWrappingArrayBaseClass(JClass itemJClass, JDefinedClass arrayClass) {
        arrayClass._extends(this._wrappingArrayBaseClass.narrow(itemJClass));
    }

    protected void generateEnum(JDefinedClass enumClass, EnumTemplateSpec enumSpec) {
        enumClass.javadoc().append((Object)enumSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)enumSpec.getSchema(), enumClass);
        this.generateSchemaField(enumClass, (DataSchema)enumSpec.getSchema());
        for (String value : enumSpec.getSchema().getSymbols()) {
            if (JavaDataTemplateGenerator.isReserved(value)) {
                throw new IllegalArgumentException("Enum contains Java reserved symbol: " + value + " schema: " + enumSpec.getSchema());
            }
            JEnumConstant enumConstant = enumClass.enumConstant(value);
            String enumConstantDoc = (String)enumSpec.getSchema().getSymbolDocs().get(value);
            if (enumConstantDoc != null) {
                enumConstant.javadoc().append((Object)enumConstantDoc);
            }
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(enumSpec.getSchema(), value, enumConstant);
        }
        enumClass.enumConstant("$UNKNOWN");
    }

    protected void generateFixed(JDefinedClass fixedClass, FixedTemplateSpec fixedSpec) {
        fixedClass.javadoc().append((Object)fixedSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)fixedSpec.getSchema(), fixedClass);
        fixedClass._extends(FixedTemplate.class);
        JFieldVar schemaField = this.generateSchemaField(fixedClass, (DataSchema)fixedSpec.getSchema());
        JMethod bytesConstructor = fixedClass.constructor(1);
        JVar param = bytesConstructor.param(ByteString.class, "value");
        bytesConstructor.body().invoke("super").arg((JExpression)param).arg((JExpression)schemaField);
        JavaDataTemplateGenerator.generateConstructorWithObjectArg(fixedClass, (JVar)schemaField);
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(fixedClass);
        }
    }

    protected void generateMap(JDefinedClass mapClass, MapTemplateSpec mapSpec) throws JClassAlreadyExistsException {
        JClass valueJClass = this.generate(mapSpec.getValueClass());
        JClass dataJClass = this.generate(mapSpec.getValueDataClass());
        if (CodeUtil.isDirectType(mapSpec.getSchema().getValues())) {
            mapClass._extends(this._directMapBaseClass.narrow(valueJClass));
        } else {
            this.extendWrappingMapBaseClass(valueJClass, mapClass);
        }
        MapDataSchema bareSchema = new MapDataSchema(JavaDataTemplateGenerator.schemaForArrayItemsOrMapValues(mapSpec.getCustomInfo(), mapSpec.getSchema().getValues()));
        JFieldVar schemaField = this.generateSchemaField(mapClass, (DataSchema)bareSchema);
        JavaDataTemplateGenerator.generateConstructorWithNoArg(mapClass, this._dataMapClass);
        this.generateConstructorWithInitialCapacity(mapClass, this._dataMapClass);
        this.generateConstructorWithInitialCapacityAndLoadFactor(mapClass);
        this.generateConstructorWithMap(mapClass, valueJClass);
        JavaDataTemplateGenerator.generateConstructorWithArg(mapClass, (JVar)schemaField, this._dataMapClass, valueJClass, dataJClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForCollection(mapClass, (DataSchema)mapSpec.getSchema(), valueJClass, "values");
        }
        this.generateCustomClassInitialization(mapClass, mapSpec.getCustomInfo());
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(mapClass);
        }
    }

    protected void extendWrappingMapBaseClass(JClass valueJClass, JDefinedClass mapClass) {
        mapClass._extends(this._wrappingMapBaseClass.narrow(valueJClass));
    }

    private JClass generatePrimitive(PrimitiveTemplateSpec primitiveSpec) {
        switch (primitiveSpec.getSchema().getType()) {
            case INT: {
                return this.getCodeModel().INT.boxify();
            }
            case DOUBLE: {
                return this.getCodeModel().DOUBLE.boxify();
            }
            case BOOLEAN: {
                return this.getCodeModel().BOOLEAN.boxify();
            }
            case STRING: {
                return this._stringClass;
            }
            case LONG: {
                return this.getCodeModel().LONG.boxify();
            }
            case FLOAT: {
                return this.getCodeModel().FLOAT.boxify();
            }
            case BYTES: {
                return this._byteStringClass;
            }
        }
        throw new RuntimeException("Not supported primitive: " + primitiveSpec);
    }

    protected void generateRecord(JDefinedClass templateClass, RecordTemplateSpec recordSpec) throws JClassAlreadyExistsException {
        templateClass.javadoc().append((Object)recordSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)recordSpec.getSchema(), templateClass);
        this.extendRecordBaseClass(templateClass);
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForRecord(recordSpec.getFields(), templateClass);
        }
        JFieldVar schemaFieldVar = this.generateSchemaField(templateClass, (DataSchema)recordSpec.getSchema());
        JavaDataTemplateGenerator.generateConstructorWithNoArg(templateClass, (JVar)schemaFieldVar, this._dataMapClass);
        JavaDataTemplateGenerator.generateConstructorWithArg(templateClass, (JVar)schemaFieldVar, this._dataMapClass);
        for (RecordTemplateSpec.Field field : recordSpec.getFields()) {
            this.generateRecordFieldAccessors(templateClass, field, this.generate(field.getType()), (JVar)schemaFieldVar);
            if (field.getCustomInfo() == null) continue;
            this.generateCustomClassInitialization(templateClass, field.getCustomInfo());
        }
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(templateClass);
        }
    }

    protected void extendRecordBaseClass(JDefinedClass templateClass) {
        templateClass._extends(this._recordBaseClass);
    }

    private void generatePathSpecMethodsForRecord(List<RecordTemplateSpec.Field> fieldSpecs, JDefinedClass templateClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(templateClass);
        for (RecordTemplateSpec.Field field : fieldSpecs) {
            JClass fieldsRefType = this._pathSpecClass;
            if (JavaDataTemplateGenerator.hasNestedFields(field.getSchemaField().getType())) {
                JClass fieldType = this.generate(field.getType());
                fieldsRefType = this.getCodeModel().ref(fieldType.fullName() + ".Fields");
            }
            JMethod constantField = fieldsNestedClass.method(1, (JType)fieldsRefType, JavaDataTemplateGenerator.escapeReserved(field.getSchemaField().getName()));
            constantField.body()._return((JExpression)JExpr._new((JClass)fieldsRefType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg(field.getSchemaField().getName()));
            if (!field.getSchemaField().getDoc().isEmpty()) {
                constantField.javadoc().append((Object)field.getSchemaField().getDoc());
            }
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(constantField, field.getSchemaField());
        }
        JVar staticFields = templateClass.field(28, (JType)fieldsNestedClass, "_fields").init((JExpression)JExpr._new((JClass)fieldsNestedClass));
        JMethod staticFieldsAccessor = templateClass.method(17, (JType)fieldsNestedClass, "fields");
        staticFieldsAccessor.body()._return((JExpression)staticFields);
    }

    private void generateRecordFieldAccessors(JDefinedClass templateClass, RecordTemplateSpec.Field field, JClass type, JVar schemaFieldVar) {
        JVar param;
        RecordDataSchema.Field schemaField = field.getSchemaField();
        DataSchema fieldSchema = schemaField.getType();
        boolean isDirect = CodeUtil.isDirectType(fieldSchema);
        String wrappedOrDirect = isDirect ? (field.getCustomInfo() == null ? "Direct" : "CustomType") : "Wrapped";
        String capitalizedName = CodeUtil.capitalize(schemaField.getName());
        String fieldFieldName = "FIELD_" + capitalizedName;
        JFieldVar fieldField = templateClass.field(28, RecordDataSchema.Field.class, fieldFieldName);
        fieldField.init((JExpression)schemaFieldVar.invoke("getField").arg(schemaField.getName()));
        JMethod has = templateClass.method(1, (JType)this.getCodeModel().BOOLEAN, "has" + capitalizedName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, has, schemaField, "Existence checker");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(has, schemaField);
        JBlock hasBody = has.body();
        JInvocation res = JExpr.invoke((String)"contains").arg((JExpression)fieldField);
        hasBody._return((JExpression)res);
        if (this._recordFieldRemove) {
            String removeName = "remove" + capitalizedName;
            JMethod remove = templateClass.method(1, (JType)this.getCodeModel().VOID, removeName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, remove, schemaField, "Remover");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(remove, schemaField);
            JBlock removeBody = remove.body();
            removeBody.invoke("remove").arg((JExpression)fieldField);
        }
        String getterName = JavaCodeUtil.getGetterName(this.getCodeModel(), (JType)type, capitalizedName);
        if (this._recordFieldAccessorWithMode) {
            JMethod getterWithMode = templateClass.method(1, (JType)type, getterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, getterWithMode, schemaField, "Getter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(getterWithMode, schemaField);
            JVar modeParam = getterWithMode.param((JType)this._getModeClass, "mode");
            JBlock getterWithModeBody = getterWithMode.body();
            res = JExpr.invoke((String)("obtain" + wrappedOrDirect)).arg((JExpression)fieldField).arg(JExpr.dotclass((JClass)type)).arg((JExpression)modeParam);
            getterWithModeBody._return((JExpression)res);
        }
        JMethod getterWithoutMode = templateClass.method(1, (JType)type, getterName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, getterWithoutMode, schemaField, "Getter");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(getterWithoutMode, schemaField);
        JBlock getterWithoutModeBody = getterWithoutMode.body();
        res = JExpr.invoke((String)("obtain" + wrappedOrDirect)).arg((JExpression)fieldField).arg(JExpr.dotclass((JClass)type)).arg((JExpression)this._strictGetMode);
        getterWithoutModeBody._return((JExpression)res);
        JClass dataClass = this.generate(field.getDataClass());
        String setterName = "set" + capitalizedName;
        if (this._recordFieldAccessorWithMode) {
            JMethod setterWithMode = templateClass.method(1, (JType)templateClass, setterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, setterWithMode, schemaField, "Setter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(setterWithMode, schemaField);
            param = setterWithMode.param((JType)type, "value");
            JVar modeParam = setterWithMode.param((JType)this._setModeClass, "mode");
            JInvocation inv = setterWithMode.body().invoke("put" + wrappedOrDirect).arg((JExpression)fieldField).arg(JExpr.dotclass((JClass)type));
            JavaDataTemplateGenerator.dataClassArg(inv, dataClass).arg((JExpression)param).arg((JExpression)modeParam);
            setterWithMode.body()._return(JExpr._this());
        }
        JMethod setter = templateClass.method(1, (JType)templateClass, setterName);
        JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, setter, schemaField, "Setter");
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(setter, schemaField);
        param = setter.param((JType)type, "value");
        JInvocation inv = setter.body().invoke("put" + wrappedOrDirect).arg((JExpression)fieldField).arg(JExpr.dotclass((JClass)type));
        JavaDataTemplateGenerator.dataClassArg(inv, dataClass).arg((JExpression)param).arg((JExpression)this._disallowNullSetMode);
        setter.body()._return(JExpr._this());
        if (!type.unboxify().equals(type)) {
            JMethod unboxifySetter = templateClass.method(1, (JType)templateClass, setterName);
            JavaDataTemplateGenerator.addAccessorDoc((JClass)templateClass, unboxifySetter, schemaField, "Setter");
            JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc(unboxifySetter, schemaField);
            param = unboxifySetter.param(type.unboxify(), "value");
            inv = unboxifySetter.body().invoke("put" + wrappedOrDirect).arg((JExpression)fieldField).arg(JExpr.dotclass((JClass)type));
            JavaDataTemplateGenerator.dataClassArg(inv, dataClass).arg((JExpression)param).arg((JExpression)this._disallowNullSetMode);
            unboxifySetter.body()._return(JExpr._this());
        }
    }

    protected void generateTyperef(JDefinedClass typerefClass, TyperefTemplateSpec typerefSpec) {
        typerefClass.javadoc().append((Object)typerefSpec.getSchema().getDoc());
        JavaDataTemplateGenerator.setDeprecatedAnnotationAndJavadoc((DataSchema)typerefSpec.getSchema(), typerefClass);
        typerefClass._extends(TyperefInfo.class);
        JFieldVar schemaField = this.generateSchemaField(typerefClass, (DataSchema)typerefSpec.getSchema());
        JMethod constructor = typerefClass.constructor(1);
        constructor.body().invoke("super").arg((JExpression)schemaField);
    }

    protected void generateUnion(JDefinedClass unionClass, UnionTemplateSpec unionSpec) throws JClassAlreadyExistsException {
        this.extendUnionBaseClass(unionClass);
        JFieldVar schemaField = this.generateSchemaField(unionClass, (DataSchema)unionSpec.getSchema());
        JavaDataTemplateGenerator.generateConstructorWithNoArg(unionClass, (JVar)schemaField, this._dataMapClass);
        JavaDataTemplateGenerator.generateConstructorWithObjectArg(unionClass, (JVar)schemaField);
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            if (member.getClassTemplateSpec() != null) {
                this.generateUnionMemberAccessors(unionClass, member, this.generate(member.getClassTemplateSpec()), this.generate(member.getDataClass()), (JVar)schemaField);
            }
            if (member.getCustomInfo() == null) continue;
            this.generateCustomClassInitialization(unionClass, member.getCustomInfo());
        }
        if (this._pathSpecMethods) {
            this.generatePathSpecMethodsForUnion(unionSpec, unionClass);
        }
        if (this._copierMethods) {
            JavaDataTemplateGenerator.generateCopierMethods(unionClass);
        }
        if (unionSpec.getTyperefClass() != null) {
            TyperefTemplateSpec typerefClassSpec = unionSpec.getTyperefClass();
            JDefinedClass typerefInfoClass = unionClass._class(JavaDataTemplateGenerator.getJModValue(typerefClassSpec.getModifiers()), JavaDataTemplateGenerator.escapeReserved(typerefClassSpec.getClassName()));
            this.generateTyperef(typerefInfoClass, typerefClassSpec);
            JFieldVar typerefInfoField = unionClass.field(28, TyperefInfo.class, "TYPEREFINFO");
            typerefInfoField.init((JExpression)JExpr._new((JClass)typerefInfoClass));
            unionClass._implements(HasTyperefInfo.class);
            JMethod typerefInfoMethod = unionClass.method(1, TyperefInfo.class, "typerefInfo");
            typerefInfoMethod.body()._return((JExpression)typerefInfoField);
        }
    }

    protected void extendUnionBaseClass(JDefinedClass unionClass) {
        unionClass._extends(this._unionBaseClass);
    }

    private void generateUnionMemberAccessors(JDefinedClass unionClass, UnionTemplateSpec.Member member, JClass memberClass, JClass dataClass, JVar schemaField) {
        DataSchema memberType = member.getSchema();
        boolean isDirect = CodeUtil.isDirectType(memberType);
        String wrappedOrDirect = isDirect ? (member.getCustomInfo() == null ? "Direct" : "CustomType") : "Wrapped";
        String memberKey = memberType.getUnionMemberKey();
        String capitalizedName = CodeUtil.getUnionMemberName(memberType);
        String memberFieldName = "MEMBER_" + capitalizedName;
        JFieldVar memberField = unionClass.field(28, DataSchema.class, memberFieldName);
        memberField.init((JExpression)schemaField.invoke("getType").arg(memberKey));
        String setterName = "set" + capitalizedName;
        JMethod createMethod = unionClass.method(17, (JType)unionClass, "create");
        JVar param = createMethod.param((JType)memberClass, "value");
        JVar newUnionVar = createMethod.body().decl((JType)unionClass, "newUnion", (JExpression)JExpr._new((JClass)unionClass));
        createMethod.body().invoke((JExpression)newUnionVar, setterName).arg((JExpression)param);
        createMethod.body()._return((JExpression)newUnionVar);
        JMethod is = unionClass.method(1, (JType)this.getCodeModel().BOOLEAN, "is" + capitalizedName);
        JBlock isBody = is.body();
        JInvocation res = JExpr.invoke((String)"memberIs").arg(memberKey);
        isBody._return((JExpression)res);
        String getterName = "get" + capitalizedName;
        JMethod getter = unionClass.method(1, (JType)memberClass, getterName);
        JBlock getterBody = getter.body();
        res = JExpr.invoke((String)("obtain" + wrappedOrDirect)).arg((JExpression)memberField).arg(JExpr.dotclass((JClass)memberClass)).arg(memberKey);
        getterBody._return((JExpression)res);
        JMethod setter = unionClass.method(1, Void.TYPE, setterName);
        param = setter.param((JType)memberClass, "value");
        JInvocation inv = setter.body().invoke("select" + wrappedOrDirect).arg((JExpression)memberField).arg(JExpr.dotclass((JClass)memberClass));
        JavaDataTemplateGenerator.dataClassArg(inv, dataClass).arg(memberKey).arg((JExpression)param);
    }

    private void generatePathSpecMethodsForUnion(UnionTemplateSpec unionSpec, JDefinedClass unionClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(unionClass);
        for (UnionTemplateSpec.Member member : unionSpec.getMembers()) {
            JClass fieldsRefType = this._pathSpecClass;
            if (JavaDataTemplateGenerator.hasNestedFields(member.getSchema())) {
                JClass unionMemberClass = this.generate(member.getClassTemplateSpec());
                fieldsRefType = this.getCodeModel().ref(unionMemberClass.fullName() + ".Fields");
            }
            JMethod accessorMethod = fieldsNestedClass.method(1, (JType)fieldsRefType, CodeUtil.getUnionMemberName(member.getSchema()));
            accessorMethod.body()._return((JExpression)JExpr._new((JClass)fieldsRefType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg(member.getSchema().getUnionMemberKey()));
        }
    }

    private void populateClassContent(ClassTemplateSpec classTemplateSpec, JDefinedClass definedClass) throws JClassAlreadyExistsException {
        if (!this._generatedClasses.containsKey(definedClass)) {
            this._generatedClasses.put(definedClass, classTemplateSpec);
            JavaCodeUtil.annotate(definedClass, "Data Template", classTemplateSpec.getLocation());
            if (classTemplateSpec instanceof ArrayTemplateSpec) {
                this.generateArray(definedClass, (ArrayTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof EnumTemplateSpec) {
                this.generateEnum(definedClass, (EnumTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof FixedTemplateSpec) {
                this.generateFixed(definedClass, (FixedTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof MapTemplateSpec) {
                this.generateMap(definedClass, (MapTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof RecordTemplateSpec) {
                this.generateRecord(definedClass, (RecordTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof TyperefTemplateSpec) {
                this.generateTyperef(definedClass, (TyperefTemplateSpec)classTemplateSpec);
            } else if (classTemplateSpec instanceof UnionTemplateSpec) {
                this.generateUnion(definedClass, (UnionTemplateSpec)classTemplateSpec);
            } else {
                throw new RuntimeException();
            }
        }
    }

    private JFieldVar generateSchemaField(JDefinedClass templateClass, DataSchema schema) {
        JInvocation parseSchemaInvocation;
        JFieldVar schemaField = templateClass.field(28, schema.getClass(), "SCHEMA");
        String schemaJson = SchemaToJsonEncoder.schemaToJson((DataSchema)schema, (JsonBuilder.Pretty)JsonBuilder.Pretty.COMPACT);
        if (schemaJson.length() < 32000) {
            parseSchemaInvocation = this._dataTemplateUtilClass.staticInvoke("parseSchema").arg(schemaJson);
        } else {
            JInvocation stringBuilderInvocation = JExpr._new((JClass)this._stringBuilderClass);
            for (int index = 0; index < schemaJson.length(); index += 32000) {
                stringBuilderInvocation = stringBuilderInvocation.invoke("append").arg(schemaJson.substring(index, Math.min(schemaJson.length(), index + 32000)));
            }
            stringBuilderInvocation = stringBuilderInvocation.invoke("toString");
            parseSchemaInvocation = this._dataTemplateUtilClass.staticInvoke("parseSchema").arg((JExpression)stringBuilderInvocation);
        }
        schemaField.init((JExpression)JExpr.cast((JType)this.getCodeModel()._ref(schema.getClass()), (JExpression)parseSchemaInvocation));
        return schemaField;
    }

    private void generatePathSpecMethodsForCollection(JDefinedClass templateClass, DataSchema schema, JClass childClass, String wildcardMethodName) throws JClassAlreadyExistsException {
        if (JavaDataTemplateGenerator.hasNestedFields(schema)) {
            JDefinedClass fieldsNestedClass = this.generatePathSpecNestedClass(templateClass);
            JClass itemsFieldType = this.getCodeModel().ref(childClass.fullName() + ".Fields");
            JMethod constantField = fieldsNestedClass.method(1, (JType)itemsFieldType, wildcardMethodName);
            constantField.body()._return((JExpression)JExpr._new((JClass)itemsFieldType).arg((JExpression)JExpr.invoke((String)"getPathComponents")).arg((JExpression)this._pathSpecClass.staticRef("WILDCARD")));
        }
    }

    private JDefinedClass generatePathSpecNestedClass(JDefinedClass templateClass) throws JClassAlreadyExistsException {
        JDefinedClass fieldsNestedClass = templateClass._class(17, "Fields");
        fieldsNestedClass._extends(this._pathSpecClass);
        JMethod constructor = fieldsNestedClass.constructor(1);
        JClass listString = this.getCodeModel().ref(List.class).narrow(String.class);
        JVar namespace = constructor.param((JType)listString, "path");
        JVar name = constructor.param(String.class, "name");
        constructor.body().invoke("super").arg((JExpression)namespace).arg((JExpression)name);
        fieldsNestedClass.constructor(1).body().invoke("super");
        return fieldsNestedClass;
    }

    private void generateCustomClassInitialization(JDefinedClass templateClass, CustomInfoSpec customInfo) {
        if (customInfo != null) {
            String customClassFullName = customInfo.getCustomClass().getNamespace() + "." + customInfo.getCustomClass().getClassName();
            templateClass.init().add((JStatement)this._customClass.staticInvoke("initializeCustomClass").arg(this.getCodeModel().ref(customClassFullName).dotclass()));
            if (customInfo.getCoercerClass() != null) {
                String coercerClassFullName = customInfo.getCoercerClass().getNamespace() + "." + customInfo.getCoercerClass().getClassName();
                templateClass.init().add((JStatement)this._customClass.staticInvoke("initializeCoercerClass").arg(this.getCodeModel().ref(coercerClassFullName).dotclass()));
            }
        }
    }

    private void generateConstructorWithInitialCapacity(JDefinedClass cls, JClass elementClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar initialCapacity = argConstructor.param((JType)this.getCodeModel().INT, "initialCapacity");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)elementClass).arg((JExpression)initialCapacity));
    }

    private void generateConstructorWithCollection(JDefinedClass cls, JClass elementClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar c = argConstructor.param((JType)this._collectionClass.narrow(elementClass), "c");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)this._dataListClass).arg((JExpression)c.invoke("size")));
        argConstructor.body().invoke("addAll").arg((JExpression)c);
    }

    private void generateConstructorWithInitialCapacityAndLoadFactor(JDefinedClass cls) {
        JMethod argConstructor = cls.constructor(1);
        JVar initialCapacity = argConstructor.param((JType)this.getCodeModel().INT, "initialCapacity");
        JVar loadFactor = argConstructor.param((JType)this.getCodeModel().FLOAT, "loadFactor");
        argConstructor.body().invoke("this").arg((JExpression)JExpr._new((JClass)this._dataMapClass).arg((JExpression)initialCapacity).arg((JExpression)loadFactor));
    }

    private void generateConstructorWithMap(JDefinedClass cls, JClass valueClass) {
        JMethod argConstructor = cls.constructor(1);
        JVar m = argConstructor.param((JType)this._mapClass.narrow(new JClass[]{this._stringClass, valueClass}), "m");
        argConstructor.body().invoke("this").arg((JExpression)JExpr.invoke((String)"newDataMapOfSize").arg((JExpression)m.invoke("size")));
        argConstructor.body().invoke("putAll").arg((JExpression)m);
    }

    static {
        Class[] predefinedClass = new Class[]{BooleanArray.class, BooleanMap.class, BytesArray.class, BytesMap.class, DoubleArray.class, DoubleMap.class, FloatArray.class, FloatMap.class, IntegerArray.class, IntegerMap.class, LongArray.class, LongMap.class, StringArray.class, StringMap.class};
        PredefinedJavaClasses = new HashMap();
        for (Class clazz : predefinedClass) {
            DataSchema schema = DataTemplateUtil.getSchema((Class)clazz);
            PredefinedJavaClasses.put(schema, clazz);
        }
        _log = LoggerFactory.getLogger(JavaDataTemplateGenerator.class);
    }

    public static class Config {
        private String _defaultPackage = null;
        private boolean _recordFieldAccessorWithMode = true;
        private boolean _recordFieldRemove = true;
        private boolean _pathSpecMethods = true;
        private boolean _copierMethods = true;

        public void setDefaultPackage(String defaultPackage) {
            this._defaultPackage = defaultPackage;
        }

        public String getDefaultPackage() {
            return this._defaultPackage;
        }

        public void setRecordFieldAccessorWithMode(boolean recordFieldAccessorWithMode) {
            this._recordFieldAccessorWithMode = recordFieldAccessorWithMode;
        }

        public boolean getRecordFieldAccessorWithMode() {
            return this._recordFieldAccessorWithMode;
        }

        public void setRecordFieldRemove(boolean recordFieldRemove) {
            this._recordFieldRemove = recordFieldRemove;
        }

        public boolean getRecordFieldRemove() {
            return this._recordFieldRemove;
        }

        public void setPathSpecMethods(boolean pathSpecMethods) {
            this._pathSpecMethods = pathSpecMethods;
        }

        public boolean getPathSpecMethods() {
            return this._pathSpecMethods;
        }

        public void setCopierMethods(boolean copierMethods) {
            this._copierMethods = copierMethods;
        }

        public boolean getCopierMethods() {
            return this._copierMethods;
        }
    }
}

