/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.generator.spec;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.pegasus.generator.spec.ArrayTemplateSpec;
import com.linkedin.pegasus.generator.spec.EnumTemplateSpec;
import com.linkedin.pegasus.generator.spec.FixedTemplateSpec;
import com.linkedin.pegasus.generator.spec.MapTemplateSpec;
import com.linkedin.pegasus.generator.spec.ModifierSpec;
import com.linkedin.pegasus.generator.spec.PrimitiveTemplateSpec;
import com.linkedin.pegasus.generator.spec.RecordTemplateSpec;
import com.linkedin.pegasus.generator.spec.TyperefTemplateSpec;
import com.linkedin.pegasus.generator.spec.UnionTemplateSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ClassTemplateSpec {
    private DataSchema _schema;
    private TyperefDataSchema _originalTyperefSchema;
    private ClassTemplateSpec _enclosingClass;
    private String _namespace;
    private String _className;
    private Set<ModifierSpec> _modifiers;
    private String _location;

    public static ClassTemplateSpec createFromDataSchema(DataSchema schema) {
        if (schema instanceof ArrayDataSchema) {
            return new ArrayTemplateSpec((ArrayDataSchema)schema);
        }
        if (schema instanceof EnumDataSchema) {
            return new EnumTemplateSpec((EnumDataSchema)schema);
        }
        if (schema instanceof FixedDataSchema) {
            return new FixedTemplateSpec((FixedDataSchema)schema);
        }
        if (schema instanceof MapDataSchema) {
            return new MapTemplateSpec((MapDataSchema)schema);
        }
        if (schema instanceof PrimitiveDataSchema) {
            return PrimitiveTemplateSpec.getInstance(schema.getType());
        }
        if (schema instanceof RecordDataSchema) {
            return new RecordTemplateSpec((RecordDataSchema)schema);
        }
        if (schema instanceof TyperefDataSchema) {
            return new TyperefTemplateSpec((TyperefDataSchema)schema);
        }
        if (schema instanceof UnionDataSchema) {
            return new UnionTemplateSpec((UnionDataSchema)schema);
        }
        throw new RuntimeException();
    }

    public DataSchema getSchema() {
        return this._schema;
    }

    public void setSchema(DataSchema schema) {
        this._schema = schema;
    }

    public TyperefDataSchema getOriginalTyperefSchema() {
        return this._originalTyperefSchema;
    }

    public void setOriginalTyperefSchema(TyperefDataSchema originalTyperefSchema) {
        this._originalTyperefSchema = originalTyperefSchema;
    }

    public ClassTemplateSpec getEnclosingClass() {
        return this._enclosingClass;
    }

    public void setEnclosingClass(ClassTemplateSpec enclosingClass) {
        this._enclosingClass = enclosingClass;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public Set<ModifierSpec> getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(ModifierSpec ... modifiers) {
        this._modifiers = new HashSet<ModifierSpec>(Arrays.asList(modifiers));
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getFullName() {
        return (this._namespace == null ? "" : this._namespace + ".") + this._className;
    }

    public void setFullName(String fullName) {
        this._namespace = fullName.substring(0, fullName.lastIndexOf(46));
        this._className = fullName.substring(this._namespace.length() + 1);
    }
}

