/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.handler.CompositeEnumTypeHandler;
import com.mybatisflex.core.keygen.MultiEntityKeyGenerator;
import com.mybatisflex.core.keygen.MultiRowKeyGenerator;
import com.mybatisflex.core.keygen.MybatisKeyGeneratorUtil;
import com.mybatisflex.core.keygen.RowKeyGenerator;
import com.mybatisflex.core.mybatis.FlexResultSetHandler;
import com.mybatisflex.core.mybatis.FlexStatementHandler;
import com.mybatisflex.core.mybatis.FlexWrapperFactory;
import com.mybatisflex.core.mybatis.MappedStatementTypes;
import com.mybatisflex.core.mybatis.MapperInvocationHandler;
import com.mybatisflex.core.mybatis.Mappers;
import com.mybatisflex.core.mybatis.SqlArgsParameterHandler;
import com.mybatisflex.core.mybatis.executor.CacheKeyBuilder;
import com.mybatisflex.core.mybatis.executor.FlexBatchExecutor;
import com.mybatisflex.core.mybatis.executor.FlexReuseExecutor;
import com.mybatisflex.core.mybatis.executor.FlexSimpleExecutor;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.util.MapUtil;

public class FlexConfiguration
extends Configuration {
    private static final Map<String, MappedStatement> dynamicMappedStatementCache = new ConcurrentHashMap<String, MappedStatement>();

    public FlexConfiguration() {
        this.setObjectWrapperFactory(new FlexWrapperFactory());
        this.setDefaultEnumTypeHandler(CompositeEnumTypeHandler.class);
    }

    public FlexConfiguration(Environment environment) {
        super(environment);
        this.setObjectWrapperFactory(new FlexWrapperFactory());
        this.setDefaultEnumTypeHandler(CompositeEnumTypeHandler.class);
    }

    public ParameterHandler newParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        String mappedStatementId = mappedStatement.getId();
        if (!mappedStatementId.endsWith("!selectKey") && parameterObject instanceof Map && ((Map)parameterObject).containsKey("$$sql_args")) {
            SqlArgsParameterHandler sqlArgsParameterHandler = new SqlArgsParameterHandler(mappedStatement, (Map)parameterObject, boundSql);
            return (ParameterHandler)this.interceptorChain.pluginAll((Object)sqlArgsParameterHandler);
        }
        return super.newParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    public ResultSetHandler newResultSetHandler(Executor executor, MappedStatement mappedStatement, RowBounds rowBounds, ParameterHandler parameterHandler, ResultHandler resultHandler, BoundSql boundSql) {
        FlexResultSetHandler resultSetHandler = new FlexResultSetHandler(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
        return (ResultSetHandler)this.interceptorChain.pluginAll((Object)resultSetHandler);
    }

    public StatementHandler newStatementHandler(Executor executor, MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        FlexStatementHandler statementHandler = new FlexStatementHandler(executor, mappedStatement, parameterObject, rowBounds, resultHandler, boundSql);
        statementHandler = (StatementHandler)this.interceptorChain.pluginAll((Object)statementHandler);
        return statementHandler;
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        ExecutorType executorType2 = executorType = executorType == null ? this.defaultExecutorType : executorType;
        CacheKeyBuilder executor = ExecutorType.BATCH == executorType ? new FlexBatchExecutor(this, transaction) : (ExecutorType.REUSE == executorType ? new FlexReuseExecutor(this, transaction) : new FlexSimpleExecutor(this, transaction));
        if (this.cacheEnabled) {
            executor = new CachingExecutor((Executor)executor);
        }
        executor = (Executor)this.interceptorChain.pluginAll((Object)executor);
        return executor;
    }

    public MappedStatement getMappedStatement(String id) {
        MappedStatement ms = super.getMappedStatement(id);
        Class<?> asType = MappedStatementTypes.getCurrentType();
        if (asType != null) {
            return (MappedStatement)MapUtil.computeIfAbsent(dynamicMappedStatementCache, (Object)(id + ":" + asType.getName()), clazz -> this.replaceResultMap(ms, TableInfoFactory.ofEntityClass(asType)));
        }
        return ms;
    }

    public void addMappedStatement(MappedStatement ms) {
        if (ms.getId().startsWith("com.mybatisflex.core.row.RowMapper.insert")) {
            ms = this.replaceRowKeyGenerator(ms);
        } else if (StringUtil.endsWithAny(ms.getId(), "insert", "insertBatch") && ms.getKeyGenerator() == NoKeyGenerator.INSTANCE) {
            ms = this.replaceEntityKeyGenerator(ms);
        } else if (StringUtil.endsWithAny(ms.getId(), "selectOneById", "selectListByIds", "selectListByQuery", "selectCursorByQuery")) {
            ms = this.replaceResultMap(ms, this.getTableInfo(ms));
        } else {
            List resultMaps = ms.getResultMaps();
            for (ResultMap resultMap : resultMaps) {
                Class clazz = resultMap.getType();
                if (clazz.getDeclaredAnnotation(Table.class) == null || !this.isDefaultResultMap(ms.getId(), resultMap.getId())) continue;
                TableInfo tableInfo = TableInfoFactory.ofEntityClass(clazz);
                ms = this.replaceResultMap(ms, tableInfo);
            }
        }
        super.addMappedStatement(ms);
    }

    private boolean isDefaultResultMap(String statementId, String resultMapId) {
        return resultMapId.equals(statementId + "-Inline");
    }

    private MappedStatement replaceResultMap(MappedStatement ms, TableInfo tableInfo) {
        if (tableInfo == null) {
            return ms;
        }
        String resultMapId = tableInfo.getEntityClass().getName();
        ResultMap resultMap = this.hasResultMap(resultMapId) ? this.getResultMap(resultMapId) : tableInfo.buildResultMap(this);
        return new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).timeout(ms.getTimeout()).statementType(ms.getStatementType()).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).keyProperty(ms.getKeyProperties() == null ? null : String.join((CharSequence)",", ms.getKeyProperties())).keyColumn(ms.getKeyColumns() == null ? null : String.join((CharSequence)",", ms.getKeyColumns())).databaseId(this.databaseId).lang(ms.getLang()).resultOrdered(ms.isResultOrdered()).resultSets(ms.getResultSets() == null ? null : String.join((CharSequence)",", ms.getResultSets())).resultMaps(Collections.singletonList(resultMap)).resultSetType(ms.getResultSetType()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache()).cache(ms.getCache()).build();
    }

    private MappedStatement replaceRowKeyGenerator(MappedStatement ms) {
        if (ms.getId().endsWith("BySql")) {
            return ms;
        }
        KeyGenerator keyGenerator = new RowKeyGenerator(ms);
        if (ms.getId().endsWith("insertBatchWithFirstRowColumns")) {
            keyGenerator = new MultiRowKeyGenerator(keyGenerator);
        }
        return new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).timeout(ms.getTimeout()).statementType(ms.getStatementType()).keyGenerator(keyGenerator).keyProperty(ms.getKeyProperties() == null ? null : String.join((CharSequence)",", ms.getKeyProperties())).keyColumn(ms.getKeyColumns() == null ? null : String.join((CharSequence)",", ms.getKeyColumns())).databaseId(this.databaseId).lang(ms.getLang()).resultOrdered(ms.isResultOrdered()).resultSets(ms.getResultSets() == null ? null : String.join((CharSequence)",", ms.getResultSets())).resultMaps(ms.getResultMaps()).resultSetType(ms.getResultSetType()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache()).cache(ms.getCache()).build();
    }

    private MappedStatement replaceEntityKeyGenerator(MappedStatement ms) {
        TableInfo tableInfo = this.getTableInfo(ms);
        if (tableInfo == null) {
            return ms;
        }
        KeyGenerator keyGenerator = MybatisKeyGeneratorUtil.createTableKeyGenerator(tableInfo, ms);
        if (keyGenerator == NoKeyGenerator.INSTANCE) {
            return ms;
        }
        if (ms.getId().endsWith("insertBatch")) {
            keyGenerator = new MultiEntityKeyGenerator(keyGenerator);
        }
        return new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).timeout(ms.getTimeout()).statementType(ms.getStatementType()).keyGenerator(keyGenerator).keyProperty(tableInfo.getKeyProperties()).keyColumn(tableInfo.getKeyColumns()).databaseId(this.databaseId).lang(ms.getLang()).resultOrdered(ms.isResultOrdered()).resultSets(ms.getResultSets() == null ? null : String.join((CharSequence)",", ms.getResultSets())).resultMaps(ms.getResultMaps()).resultSetType(ms.getResultSetType()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache()).cache(ms.getCache()).build();
    }

    private TableInfo getTableInfo(MappedStatement ms) {
        String mapperClassName = ms.getId().substring(0, ms.getId().lastIndexOf("."));
        try {
            Class<?> mapperClass = Class.forName(mapperClassName);
            return TableInfoFactory.ofMapperClass(mapperClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> void addMapper(Class<T> type) {
        Type[] genericInterfaces = type.getGenericInterfaces();
        boolean isGenericInterface = false;
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            Type actualTypeArgument = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof Class) {
                Mappers.addMapping((Class)actualTypeArgument, type);
                continue;
            }
            isGenericInterface = true;
            break;
        }
        if (!isGenericInterface) {
            super.addMapper(type);
        }
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        Object mapper = super.getMapper(type, sqlSession);
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new MapperInvocationHandler(mapper, this.environment.getDataSource()));
    }
}

