/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Listener;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.exception.FlexAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class FlexGlobalConfig {
    private boolean printBanner = true;
    private DbType dbType = DbType.MYSQL;
    private Configuration configuration;
    private SqlSessionFactory sqlSessionFactory;
    private KeyConfig keyConfig;
    private Map<Class<?>, List<SetListener>> entitySetListeners = new ConcurrentHashMap();
    private Map<Class<?>, List<UpdateListener>> entityUpdateListeners = new ConcurrentHashMap();
    private Map<Class<?>, List<InsertListener>> entityInsertListeners = new ConcurrentHashMap();
    private Object normalValueOfLogicDelete = 0;
    private Object deletedValueOfLogicDelete = 1;
    private int defaultPageSize = 10;
    private int defaultRelationQueryDepth = 2;
    private String logicDeleteColumn;
    private String tenantColumn;
    private String versionColumn;
    private static ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs = new ConcurrentHashMap();
    private static FlexGlobalConfig defaultConfig = new FlexGlobalConfig();

    public boolean isPrintBanner() {
        return this.printBanner;
    }

    public void setPrintBanner(boolean printBanner) {
        this.printBanner = printBanner;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        DataSource dataSource = configuration.getEnvironment().getDataSource();
        if (dataSource instanceof FlexDataSource) {
            this.dbType = ((FlexDataSource)dataSource).getDefaultDbType();
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public KeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    public void setKeyConfig(KeyConfig keyConfig) {
        this.keyConfig = keyConfig;
    }

    public Map<Class<?>, List<SetListener>> getEntitySetListeners() {
        return this.entitySetListeners;
    }

    public void setEntitySetListeners(Map<Class<?>, List<SetListener>> entitySetListeners) {
        this.entitySetListeners = entitySetListeners;
    }

    public Map<Class<?>, List<UpdateListener>> getEntityUpdateListeners() {
        return this.entityUpdateListeners;
    }

    public void setEntityUpdateListeners(Map<Class<?>, List<UpdateListener>> entityUpdateListeners) {
        this.entityUpdateListeners = entityUpdateListeners;
    }

    public Map<Class<?>, List<InsertListener>> getEntityInsertListeners() {
        return this.entityInsertListeners;
    }

    public void setEntityInsertListeners(Map<Class<?>, List<InsertListener>> entityInsertListeners) {
        this.entityInsertListeners = entityInsertListeners;
    }

    public void registerSetListener(SetListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entitySetListeners.computeIfAbsent(aClass, k -> new ArrayList()).add(listener);
        }
    }

    public void registerUpdateListener(UpdateListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityUpdateListeners.computeIfAbsent(aClass, k -> new ArrayList()).add(listener);
        }
    }

    public void registerInsertListener(InsertListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityInsertListeners.computeIfAbsent(aClass, k -> new ArrayList()).add(listener);
        }
    }

    public List<SetListener> getSetListener(Class<?> entityClass) {
        return this.entitySetListeners.get(entityClass);
    }

    public List<SetListener> getSupportedSetListener(Class<?> entityClass) {
        return this.findSupportedListeners(entityClass, this.entitySetListeners);
    }

    public List<UpdateListener> getUpdateListener(Class<?> entityClass) {
        return this.entityUpdateListeners.get(entityClass);
    }

    public <T extends Listener> List<T> findSupportedListeners(Class<?> entityClass, Map<Class<?>, List<T>> listenerMap) {
        return listenerMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(entityClass)).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    public List<UpdateListener> getSupportedUpdateListener(Class<?> entityClass) {
        return this.findSupportedListeners(entityClass, this.entityUpdateListeners);
    }

    public List<InsertListener> getInsertListener(Class<?> entityClass) {
        return this.entityInsertListeners.get(entityClass);
    }

    public List<InsertListener> getSupportedInsertListener(Class<?> entityClass) {
        return this.findSupportedListeners(entityClass, this.entityInsertListeners);
    }

    public Object getNormalValueOfLogicDelete() {
        return this.normalValueOfLogicDelete;
    }

    public void setNormalValueOfLogicDelete(Object normalValueOfLogicDelete) {
        FlexAssert.notNull(normalValueOfLogicDelete, "normalValueOfLogicDelete");
        this.normalValueOfLogicDelete = normalValueOfLogicDelete;
    }

    public Object getDeletedValueOfLogicDelete() {
        return this.deletedValueOfLogicDelete;
    }

    public void setDeletedValueOfLogicDelete(Object deletedValueOfLogicDelete) {
        FlexAssert.notNull(deletedValueOfLogicDelete, "deletedValueOfLogicDelete");
        this.deletedValueOfLogicDelete = deletedValueOfLogicDelete;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(int defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public int getDefaultRelationQueryDepth() {
        return this.defaultRelationQueryDepth;
    }

    public void setDefaultRelationQueryDepth(int defaultRelationQueryDepth) {
        this.defaultRelationQueryDepth = defaultRelationQueryDepth;
    }

    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    public String getTenantColumn() {
        return this.tenantColumn;
    }

    public void setTenantColumn(String tenantColumn) {
        this.tenantColumn = tenantColumn;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public FlexDataSource getDataSource() {
        return (FlexDataSource)this.getConfiguration().getEnvironment().getDataSource();
    }

    public static ConcurrentHashMap<String, FlexGlobalConfig> getGlobalConfigs() {
        return globalConfigs;
    }

    public static void setGlobalConfigs(ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs) {
        FlexGlobalConfig.globalConfigs = globalConfigs;
    }

    public static FlexGlobalConfig getDefaultConfig() {
        return defaultConfig;
    }

    public static void setDefaultConfig(FlexGlobalConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null.");
        }
        defaultConfig = config;
    }

    public static FlexGlobalConfig getConfig(Configuration configuration) {
        return FlexGlobalConfig.getConfig(configuration.getEnvironment().getId());
    }

    public static FlexGlobalConfig getConfig(String environmentId) {
        return globalConfigs.get(environmentId);
    }

    public static synchronized void setConfig(String id, FlexGlobalConfig config, boolean isDefault) {
        if (isDefault) {
            defaultConfig.setSqlSessionFactory(config.sqlSessionFactory);
            defaultConfig.setConfiguration(config.configuration);
        }
        globalConfigs.put(id, isDefault ? defaultConfig : config);
    }

    public static class KeyConfig {
        private KeyType keyType;
        private String value;
        private boolean before = true;

        public KeyType getKeyType() {
            return this.keyType;
        }

        public void setKeyType(KeyType keyType) {
            this.keyType = keyType;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isBefore() {
            return this.before;
        }

        public void setBefore(boolean before) {
            this.before = before;
        }
    }
}

